/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.util.Dependencies;

public class LogFilesBuilder {
    private boolean readOnly;
    private PageCache pageCache;
    private File storeDirectory;
    private File logsDirectory;
    private Config config;
    private Long rotationThreshold;
    private LogEntryReader logEntryReader;
    private LogFileCreationMonitor logFileCreationMonitor;
    private Dependencies dependencies;
    private FileSystemAbstraction fileSystem;
    private LogVersionRepository logVersionRepository;
    private TransactionIdStore transactionIdStore;
    private LongSupplier lastCommittedTransactionIdSupplier;
    private String logFileName = "neostore.transaction.db";
    private boolean fileBasedOperationsOnly;

    public static LogFilesBuilder builder(File storeDirectory, FileSystemAbstraction fileSystem) {
        LogFilesBuilder filesBuilder = new LogFilesBuilder();
        filesBuilder.storeDirectory = storeDirectory;
        filesBuilder.fileSystem = fileSystem;
        return filesBuilder;
    }

    public static LogFilesBuilder activeFilesBuilder(File storeDirectory, FileSystemAbstraction fileSystem, PageCache pageCache) {
        LogFilesBuilder builder = LogFilesBuilder.builder(storeDirectory, fileSystem);
        builder.pageCache = pageCache;
        builder.readOnly = true;
        return builder;
    }

    public static LogFilesBuilder logFilesBasedOnlyBuilder(File logsDirectory, FileSystemAbstraction fileSystem) {
        LogFilesBuilder builder = new LogFilesBuilder();
        builder.logsDirectory = logsDirectory;
        builder.fileSystem = fileSystem;
        builder.fileBasedOperationsOnly = true;
        return builder;
    }

    LogFilesBuilder withLogFileName(String name) {
        this.logFileName = name;
        return this;
    }

    public LogFilesBuilder withLogVersionRepository(LogVersionRepository logVersionRepository) {
        this.logVersionRepository = logVersionRepository;
        return this;
    }

    public LogFilesBuilder withTransactionIdStore(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
        return this;
    }

    public LogFilesBuilder withLastCommittedTransactionIdSupplier(LongSupplier transactionIdSupplier) {
        this.lastCommittedTransactionIdSupplier = transactionIdSupplier;
        return this;
    }

    public LogFilesBuilder withLogEntryReader(LogEntryReader logEntryReader) {
        this.logEntryReader = logEntryReader;
        return this;
    }

    public LogFilesBuilder withLogFileMonitor(LogFileCreationMonitor logFileCreationMonitor) {
        this.logFileCreationMonitor = logFileCreationMonitor;
        return this;
    }

    public LogFilesBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public LogFilesBuilder withRotationThreshold(long rotationThreshold) {
        this.rotationThreshold = rotationThreshold;
        return this;
    }

    public LogFilesBuilder withDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public LogFiles build() throws IOException {
        TransactionLogFilesContext filesContext = this.buildContext();
        File logsDirectory = this.getLogsDirectory();
        filesContext.getFileSystem().mkdirs(logsDirectory);
        return new TransactionLogFiles(logsDirectory, this.logFileName, filesContext);
    }

    private File getLogsDirectory() {
        if (this.logsDirectory != null) {
            return this.logsDirectory;
        }
        if (this.config != null) {
            File neo4jHome = this.config.get(GraphDatabaseSettings.neo4j_home);
            File databasePath = this.config.get(GraphDatabaseSettings.database_path);
            File logicalLogsLocation = this.config.get(GraphDatabaseSettings.logical_logs_location);
            if (this.storeDirectory.equals(neo4jHome) && databasePath.equals(logicalLogsLocation)) {
                return this.storeDirectory;
            }
            if (logicalLogsLocation.isAbsolute()) {
                return logicalLogsLocation;
            }
            if (neo4jHome == null || !this.storeDirectory.equals(databasePath)) {
                Path relativeLogicalLogPath = databasePath.toPath().relativize(logicalLogsLocation.toPath());
                return new File(this.storeDirectory, relativeLogicalLogPath.toString());
            }
            return logicalLogsLocation;
        }
        return this.storeDirectory;
    }

    TransactionLogFilesContext buildContext() throws IOException {
        if (this.logEntryReader == null) {
            this.logEntryReader = new VersionAwareLogEntryReader();
        }
        if (this.logFileCreationMonitor == null) {
            this.logFileCreationMonitor = LogFileCreationMonitor.NO_MONITOR;
        }
        Objects.requireNonNull(this.fileSystem);
        Supplier<LogVersionRepository> logVersionRepositorySupplier = this.getLogVersionRepositorySupplier();
        LongSupplier lastCommittedIdSupplier = this.lastCommittedIdSupplier();
        LongSupplier committingTransactionIdSupplier = this.committingIdSupplier();
        long rotationThreshold = this.getRotationThreshold();
        return new TransactionLogFilesContext(rotationThreshold, this.logEntryReader, lastCommittedIdSupplier, committingTransactionIdSupplier, this.logFileCreationMonitor, logVersionRepositorySupplier, this.fileSystem);
    }

    private long getRotationThreshold() {
        if (this.rotationThreshold != null) {
            return this.rotationThreshold;
        }
        if (this.readOnly) {
            return Long.MAX_VALUE;
        }
        if (this.config == null) {
            this.config = Config.defaults();
        }
        return this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold);
    }

    private Supplier<LogVersionRepository> getLogVersionRepositorySupplier() throws IOException {
        if (this.logVersionRepository != null) {
            return () -> this.logVersionRepository;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of log version repository. Please build full version of log files. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read current log version.");
            Objects.requireNonNull(this.storeDirectory, "Store directory is required.");
            ReadOnlyLogVersionRepository logVersionRepository = new ReadOnlyLogVersionRepository(this.pageCache, this.storeDirectory);
            return () -> logVersionRepository;
        }
        Objects.requireNonNull(this.dependencies, LogVersionRepository.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return this.getSupplier(LogVersionRepository.class);
    }

    private LongSupplier lastCommittedIdSupplier() throws IOException {
        if (this.lastCommittedTransactionIdSupplier != null) {
            return this.lastCommittedTransactionIdSupplier;
        }
        if (this.transactionIdStore != null) {
            return this.transactionIdStore::getLastCommittedTransactionId;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read commited transaction info from store store.");
            Objects.requireNonNull(this.storeDirectory, "Store directory is required.");
            ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, this.storeDirectory);
            return transactionIdStore::getLastCommittedTransactionId;
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> this.resolveDependency(TransactionIdStore.class).getLastCommittedTransactionId();
    }

    private LongSupplier committingIdSupplier() throws IOException {
        if (this.transactionIdStore != null) {
            return this.transactionIdStore::committingTransactionId;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of transaction id store. Please build full version of log files to be able to use them.");
            };
        }
        if (this.readOnly) {
            Objects.requireNonNull(this.pageCache, "Read only log files require page cache to be able to read commited transaction info from store store.");
            Objects.requireNonNull(this.storeDirectory, "Store directory is required.");
            ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, this.storeDirectory);
            return transactionIdStore::committingTransactionId;
        }
        Objects.requireNonNull(this.dependencies, TransactionIdStore.class.getSimpleName() + " is required. Please provide an instance or a dependencies where it can be found.");
        return () -> this.resolveDependency(TransactionIdStore.class).committingTransactionId();
    }

    private <T> Supplier<T> getSupplier(Class<T> clazz) {
        return () -> this.resolveDependency(clazz);
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.dependencies.resolveDependency(clazz);
    }
}

