/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleDeserializer2_0to3_1;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;

public class SchemaRuleSerialization {
    private static final byte INDEX_RULE = 11;
    private static final byte CONSTRAINT_RULE = 12;
    private static final byte GENERAL_INDEX = 31;
    private static final byte UNIQUE_INDEX = 32;
    private static final byte EXISTS_CONSTRAINT = 61;
    private static final byte UNIQUE_CONSTRAINT = 62;
    private static final byte UNIQUE_EXISTS_CONSTRAINT = 63;
    private static final byte SIMPLE_LABEL = 91;
    private static final byte SIMPLE_REL_TYPE = 92;
    private static final long NO_OWNING_CONSTRAINT_YET = -1L;
    private static final int LEGACY_LABEL_OR_REL_TYPE_ID = -1;
    private static SchemaComputer<Integer> schemaSizeComputer = new SchemaComputer<Integer>(){

        public Integer computeSpecific(LabelSchemaDescriptor schema) {
            return 7 + 4 * schema.getPropertyIds().length;
        }

        public Integer computeSpecific(RelationTypeSchemaDescriptor schema) {
            return 7 + 4 * schema.getPropertyIds().length;
        }
    };

    private SchemaRuleSerialization() {
    }

    public static SchemaRule deserialize(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        int legacyLabelOrRelTypeId = source.getInt();
        byte schemaRuleType = source.get();
        switch (schemaRuleType) {
            case 11: {
                return SchemaRuleSerialization.readIndexRule(id, source);
            }
            case 12: {
                return SchemaRuleSerialization.readConstraintRule(id, source);
            }
        }
        if (SchemaRuleDeserializer2_0to3_1.isLegacySchemaRule(schemaRuleType)) {
            return SchemaRuleDeserializer2_0to3_1.deserialize(id, legacyLabelOrRelTypeId, schemaRuleType, source);
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema rule type '%d'.", schemaRuleType));
    }

    public static byte[] serialize(IndexRule indexRule) {
        ByteBuffer target = ByteBuffer.allocate(SchemaRuleSerialization.lengthOf(indexRule));
        target.putInt(-1);
        target.put((byte)11);
        SchemaIndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
        UTF8.putEncodedStringInto((String)providerDescriptor.getKey(), (ByteBuffer)target);
        UTF8.putEncodedStringInto((String)providerDescriptor.getVersion(), (ByteBuffer)target);
        IndexDescriptor indexDescriptor = indexRule.getIndexDescriptor();
        switch (indexDescriptor.type()) {
            case GENERAL: {
                target.put((byte)31);
                break;
            }
            case UNIQUE: {
                target.put((byte)32);
                Long owningConstraint = indexRule.getOwningConstraint();
                target.putLong(owningConstraint == null ? -1L : owningConstraint);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Got unknown index descriptor type '%s'.", new Object[]{indexDescriptor.type()}));
            }
        }
        indexDescriptor.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
        UTF8.putEncodedStringInto((String)indexRule.getName(), (ByteBuffer)target);
        return target.array();
    }

    public static byte[] serialize(ConstraintRule constraintRule) {
        ByteBuffer target = ByteBuffer.allocate(SchemaRuleSerialization.lengthOf(constraintRule));
        target.putInt(-1);
        target.put((byte)12);
        ConstraintDescriptor constraintDescriptor = constraintRule.getConstraintDescriptor();
        switch (constraintDescriptor.type()) {
            case EXISTS: {
                target.put((byte)61);
                break;
            }
            case UNIQUE: {
                target.put((byte)62);
                target.putLong(constraintRule.getOwnedIndex());
                break;
            }
            case UNIQUE_EXISTS: {
                target.put((byte)63);
                target.putLong(constraintRule.getOwnedIndex());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Got unknown index descriptor type '%s'.", constraintDescriptor.type()));
            }
        }
        constraintDescriptor.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
        UTF8.putEncodedStringInto((String)constraintRule.getName(), (ByteBuffer)target);
        return target.array();
    }

    public static int lengthOf(IndexRule indexRule) {
        int length = 4;
        ++length;
        SchemaIndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
        length += UTF8.computeRequiredByteBufferSize((String)providerDescriptor.getKey());
        length += UTF8.computeRequiredByteBufferSize((String)providerDescriptor.getVersion());
        ++length;
        IndexDescriptor indexDescriptor = indexRule.getIndexDescriptor();
        if (indexDescriptor.type() == IndexDescriptor.Type.UNIQUE) {
            length += 8;
        }
        length += ((Integer)indexDescriptor.schema().computeWith(schemaSizeComputer)).intValue();
        return length += UTF8.computeRequiredByteBufferSize((String)indexRule.getName());
    }

    public static int lengthOf(ConstraintRule constraintRule) {
        int length = 4;
        ++length;
        ++length;
        ConstraintDescriptor constraintDescriptor = constraintRule.getConstraintDescriptor();
        if (constraintDescriptor.enforcesUniqueness()) {
            length += 8;
        }
        length += ((Integer)constraintDescriptor.schema().computeWith(schemaSizeComputer)).intValue();
        return length += UTF8.computeRequiredByteBufferSize((String)constraintRule.getName());
    }

    private static IndexRule readIndexRule(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        SchemaIndexProvider.Descriptor indexProvider = SchemaRuleSerialization.readIndexProviderDescriptor(source);
        byte indexRuleType = source.get();
        switch (indexRuleType) {
            case 31: {
                LabelSchemaDescriptor schema = SchemaRuleSerialization.readLabelSchema(source);
                String name = SchemaRuleSerialization.readRuleName(id, IndexRule.class, source);
                return IndexRule.indexRule(id, IndexDescriptorFactory.forSchema(schema), indexProvider, name);
            }
            case 32: {
                long owningConstraint = source.getLong();
                LabelSchemaDescriptor schema = SchemaRuleSerialization.readLabelSchema(source);
                IndexDescriptor descriptor = IndexDescriptorFactory.uniqueForSchema(schema);
                String name = SchemaRuleSerialization.readRuleName(id, IndexRule.class, source);
                return IndexRule.constraintIndexRule(id, descriptor, indexProvider, owningConstraint == -1L ? null : Long.valueOf(owningConstraint), name);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown index rule type '%d'.", indexRuleType));
    }

    private static LabelSchemaDescriptor readLabelSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        SchemaDescriptor schemaDescriptor = SchemaRuleSerialization.readSchema(source);
        if (!(schemaDescriptor instanceof LabelSchemaDescriptor)) {
            throw new MalformedSchemaRuleException("IndexRules must have LabelSchemaDescriptors, got " + schemaDescriptor.getClass().getSimpleName());
        }
        return (LabelSchemaDescriptor)schemaDescriptor;
    }

    private static SchemaIndexProvider.Descriptor readIndexProviderDescriptor(ByteBuffer source) {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)source);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)source);
        return new SchemaIndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static ConstraintRule readConstraintRule(long id, ByteBuffer source) throws MalformedSchemaRuleException {
        byte constraintRuleType = source.get();
        switch (constraintRuleType) {
            case 61: {
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                String name = SchemaRuleSerialization.readRuleName(id, ConstraintRule.class, source);
                return ConstraintRule.constraintRule(id, ConstraintDescriptorFactory.existsForSchema(schema), name);
            }
            case 62: {
                long ownedUniqueIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                UniquenessConstraintDescriptor descriptor = ConstraintDescriptorFactory.uniqueForSchema(schema);
                String name = SchemaRuleSerialization.readRuleName(id, ConstraintRule.class, source);
                return ConstraintRule.constraintRule(id, descriptor, ownedUniqueIndex, name);
            }
            case 63: {
                long ownedNodeKeyIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                NodeKeyConstraintDescriptor nodeKeyConstraintDescriptor = ConstraintDescriptorFactory.nodeKeyForSchema(schema);
                String name = SchemaRuleSerialization.readRuleName(id, ConstraintRule.class, source);
                return ConstraintRule.constraintRule(id, nodeKeyConstraintDescriptor, ownedNodeKeyIndex, name);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown constraint rule type '%d'.", constraintRuleType));
    }

    private static String readRuleName(long id, Class<? extends SchemaRule> type, ByteBuffer source) {
        String ruleName = null;
        if (source.remaining() >= 4) {
            ruleName = UTF8.getDecodedStringFrom((ByteBuffer)source);
        }
        if (ruleName == null || ruleName.isEmpty()) {
            ruleName = SchemaRule.generateName(id, type);
        }
        return ruleName;
    }

    private static SchemaDescriptor readSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        byte schemaDescriptorType = source.get();
        switch (schemaDescriptorType) {
            case 91: {
                int labelId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization.readPropertyIds(source);
                return SchemaDescriptorFactory.forLabel(labelId, propertyIds);
            }
            case 92: {
                int relTypeId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization.readPropertyIds(source);
                return SchemaDescriptorFactory.forRelType(relTypeId, propertyIds);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema descriptor type '%d'.", schemaDescriptorType));
    }

    private static int[] readPropertyIds(ByteBuffer source) {
        int numProperties = source.getShort();
        int[] propertyIds = new int[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            propertyIds[i] = source.getInt();
        }
        return propertyIds;
    }

    private static class SchemaDescriptorSerializer
    implements SchemaProcessor {
        private final ByteBuffer target;

        SchemaDescriptorSerializer(ByteBuffer target) {
            this.target = target;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            this.target.put((byte)91);
            this.target.putInt(schema.getLabelId());
            int[] propertyIds = schema.getPropertyIds();
            this.target.putShort((short)propertyIds.length);
            for (int propertyId : propertyIds) {
                this.target.putInt(propertyId);
            }
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.target.put((byte)92);
            this.target.putInt(schema.getRelTypeId());
            int[] propertyIds = schema.getPropertyIds();
            this.target.putShort((short)propertyIds.length);
            for (int propertyId : propertyIds) {
                this.target.putInt(propertyId);
            }
        }
    }
}

