/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.Closeable;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;

public interface IdGenerator
extends IdSequence,
Closeable {
    @Override
    public IdRange nextIdBatch(int var1);

    public void setHighId(long var1);

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public void freeId(long var1);

    @Override
    public void close();

    public long getNumberOfIdsInUse();

    public long getDefragCount();

    public void delete();

    public static class Delegate
    implements IdGenerator {
        private final IdGenerator delegate;

        public Delegate(IdGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long nextId() {
            return this.delegate.nextId();
        }

        @Override
        public IdRange nextIdBatch(int size) {
            return this.delegate.nextIdBatch(size);
        }

        @Override
        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        @Override
        public long getHighId() {
            return this.delegate.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        @Override
        public void freeId(long id) {
            this.delegate.freeId(id);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.delegate.getNumberOfIdsInUse();
        }

        @Override
        public long getDefragCount() {
            return this.delegate.getDefragCount();
        }

        @Override
        public void delete() {
            this.delegate.delete();
        }
    }
}

