/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;

public class StoreFactory {
    public static final String LABELS_PART = ".labels";
    public static final String NAMES_PART = ".names";
    public static final String INDEX_PART = ".index";
    public static final String KEYS_PART = ".keys";
    public static final String ARRAYS_PART = ".arrays";
    public static final String STRINGS_PART = ".strings";
    public static final String NODE_STORE_NAME = ".nodestore.db";
    public static final String NODE_LABELS_STORE_NAME = ".nodestore.db.labels";
    public static final String PROPERTY_STORE_NAME = ".propertystore.db";
    public static final String PROPERTY_KEY_TOKEN_STORE_NAME = ".propertystore.db.index";
    public static final String PROPERTY_KEY_TOKEN_NAMES_STORE_NAME = ".propertystore.db.index.keys";
    public static final String PROPERTY_STRINGS_STORE_NAME = ".propertystore.db.strings";
    public static final String PROPERTY_ARRAYS_STORE_NAME = ".propertystore.db.arrays";
    public static final String RELATIONSHIP_STORE_NAME = ".relationshipstore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_STORE_NAME = ".relationshiptypestore.db";
    public static final String RELATIONSHIP_TYPE_TOKEN_NAMES_STORE_NAME = ".relationshiptypestore.db.names";
    public static final String LABEL_TOKEN_STORE_NAME = ".labeltokenstore.db";
    public static final String LABEL_TOKEN_NAMES_STORE_NAME = ".labeltokenstore.db.names";
    public static final String SCHEMA_STORE_NAME = ".schemastore.db";
    public static final String RELATIONSHIP_GROUP_STORE_NAME = ".relationshipgroupstore.db";
    public static final String COUNTS_STORE = ".counts.db";
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final LogProvider logProvider;
    private final File neoStoreFileName;
    private final PageCache pageCache;
    private final RecordFormats recordFormats;
    private final OpenOption[] openOptions;

    public StoreFactory(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider) {
        this(storeDir, config, idGeneratorFactory, pageCache, fileSystemAbstraction, RecordFormatSelector.selectForStoreOrConfig(config, storeDir, pageCache, logProvider), logProvider);
    }

    public StoreFactory(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, RecordFormats recordFormats, LogProvider logProvider) {
        this(storeDir, "neostore", config, idGeneratorFactory, pageCache, fileSystemAbstraction, recordFormats, logProvider, new OpenOption[0]);
    }

    public StoreFactory(File storeDir, String storeName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, RecordFormats recordFormats, LogProvider logProvider, OpenOption ... openOptions) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.recordFormats = recordFormats;
        this.openOptions = openOptions;
        new RecordFormatPropertyConfigurator(recordFormats, config).configure();
        this.logProvider = logProvider;
        this.neoStoreFileName = new File(storeDir, storeName);
        this.pageCache = pageCache;
    }

    public NeoStores openAllNeoStores() {
        return this.openNeoStores(false, StoreType.values());
    }

    public NeoStores openAllNeoStores(boolean createStoreIfNotExists) {
        return this.openNeoStores(createStoreIfNotExists, StoreType.values());
    }

    public NeoStores openNeoStores(StoreType ... storeTypes) {
        return this.openNeoStores(false, storeTypes);
    }

    public NeoStores openNeoStores(boolean createStoreIfNotExists, StoreType ... storeTypes) {
        if (createStoreIfNotExists) {
            try {
                this.fileSystemAbstraction.mkdirs(this.neoStoreFileName.getParentFile());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not create store directory: " + this.neoStoreFileName.getParent(), e);
            }
        }
        return new NeoStores(this.neoStoreFileName, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.fileSystemAbstraction, this.recordFormats, createStoreIfNotExists, storeTypes, this.openOptions);
    }
}

