/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;
import org.neo4j.values.storable.Value;

class NodeValueIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.NodeValueIndexCursor,
IndexProgressor.NodeValueClient {
    private Read read;
    private long node = -1L;
    private IndexQuery[] query;
    private Value[] values;
    private PrimitiveLongIterator added;
    private PrimitiveLongReadableDiffSets changes;

    NodeValueIndexCursor() {
    }

    @Override
    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query) {
        assert (query != null && query.length > 0);
        super.initialize(progressor);
        IndexQuery firstPredicate = query[0];
        switch (firstPredicate.type()) {
            case exact: {
                this.seekQuery(descriptor, query);
                break;
            }
            case stringSuffix: 
            case stringContains: 
            case exists: {
                this.scanQuery(descriptor);
                break;
            }
            case rangeNumeric: {
                assert (query.length == 1);
                this.numericRangeQuery(descriptor, (IndexQuery.NumberRangePredicate)query[0]);
                break;
            }
            case rangeString: {
                assert (query.length == 1);
                this.stringRangeQuery(descriptor, (IndexQuery.StringRangePredicate)query[0]);
                break;
            }
            case stringPrefix: {
                this.prefixQuery(descriptor, (IndexQuery.StringPrefixPredicate)query[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(query));
            }
        }
    }

    private boolean isRemoved(long reference) {
        return this.changes != null && this.changes.isRemoved(reference) || this.read.hasTxStateWithChanges() && this.read.txState().addedAndRemovedNodes().isRemoved(reference);
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        if (this.isRemoved(reference)) {
            return false;
        }
        this.node = reference;
        this.values = values;
        return true;
    }

    public boolean next() {
        if (this.added != null && this.added.hasNext()) {
            this.node = this.added.next();
            this.values = null;
            return true;
        }
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public int numberOfProperties() {
        return this.query == null ? 0 : this.query.length;
    }

    public int propertyKey(int offset) {
        return this.query[offset].propertyKeyId();
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public Value propertyValue(int offset) {
        return this.values[offset];
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.query = null;
        this.values = null;
        this.read = null;
        this.added = null;
        this.changes = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeValueIndexCursor[closed state]";
        }
        return "NodeValueIndexCursor[node=" + this.node + ", open state with: keys=" + Arrays.toString(Arrays.stream(this.query).map(IndexQuery::propertyKeyId).toArray(Integer[]::new)) + ", values=" + Arrays.toString(this.values) + ", underlying record=" + super.toString() + " ]";
    }

    private void prefixQuery(IndexDescriptor descriptor, IndexQuery.StringPrefixPredicate predicate) {
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().indexUpdatesForRangeSeekByPrefix(descriptor, predicate.prefix());
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }

    private void stringRangeQuery(IndexDescriptor descriptor, IndexQuery.StringRangePredicate predicate) {
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().indexUpdatesForRangeSeekByString(descriptor, predicate.from(), predicate.fromInclusive(), predicate.to(), predicate.toInclusive());
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }

    private void numericRangeQuery(IndexDescriptor descriptor, IndexQuery.NumberRangePredicate predicate) {
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().indexUpdatesForRangeSeekByNumber(descriptor, predicate.from(), predicate.fromInclusive(), predicate.to(), predicate.toInclusive());
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }

    private void scanQuery(IndexDescriptor descriptor) {
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().indexUpdatesForScan(descriptor);
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }

    private void seekQuery(IndexDescriptor descriptor, IndexQuery[] query) {
        IndexQuery.ExactPredicate[] exactPreds = StateHandlingStatementOperations.assertOnlyExactPredicates(query);
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().indexUpdatesForSeek(descriptor, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])exactPreds));
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }
}

