/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;

class FusionIndexUpdater
implements IndexUpdater {
    private final IndexUpdater nativeUpdater;
    private final IndexUpdater luceneUpdater;
    private final FusionSchemaIndexProvider.Selector selector;

    FusionIndexUpdater(IndexUpdater nativeUpdater, IndexUpdater luceneUpdater, FusionSchemaIndexProvider.Selector selector) {
        this.nativeUpdater = nativeUpdater;
        this.luceneUpdater = luceneUpdater;
        this.selector = selector;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                this.selector.select(this.nativeUpdater, this.luceneUpdater, update.values()).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = this.selector.select(this.nativeUpdater, this.luceneUpdater, update.beforeValues());
                IndexUpdater to = this.selector.select(this.nativeUpdater, this.luceneUpdater, update.values());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                this.selector.select(this.nativeUpdater, this.luceneUpdater, update.values()).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        try {
            this.nativeUpdater.close();
        }
        finally {
            this.luceneUpdater.close();
        }
    }
}

