/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.graphdb.Resource;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIndexAccessor;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class LabelScanValueIndexProgressor
extends LabelScanValueIndexAccessor
implements IndexProgressor,
Resource {
    private final IndexProgressor.NodeLabelClient client;

    LabelScanValueIndexProgressor(RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor, Collection<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> toRemoveFromWhenClosed, IndexProgressor.NodeLabelClient client) {
        super(toRemoveFromWhenClosed, cursor);
        this.client = client;
    }

    @Override
    public boolean next() {
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                if (!this.client.acceptNode(this.baseNodeId + (long)delta, null)) continue;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Hit hit = (Hit)this.cursor.get();
            this.baseNodeId = ((LabelScanKey)hit.key()).idRange * 64L;
            this.bits = ((LabelScanValue)hit.value()).bits;
            if (!$assertionsDisabled && !this.keysInOrder((LabelScanKey)hit.key())) break;
        }
        throw new AssertionError();
    }
}

