/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;

public class StandardNodeActions
implements NodeProxy.NodeActions {
    private final Supplier<Statement> stmt;
    private final Supplier<KernelTransaction> currentTx;
    private final ThrowingAction<RuntimeException> assertInOpenTransaction;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final GraphDatabaseService gds;

    public StandardNodeActions(Supplier<Statement> stmt, Supplier<KernelTransaction> currentTx, ThrowingAction<RuntimeException> assertTransactionOpen, RelationshipProxy.RelationshipActions relationshipActions, GraphDatabaseService gds) {
        this.stmt = stmt;
        this.currentTx = currentTx;
        this.assertInOpenTransaction = assertTransactionOpen;
        this.relationshipActions = relationshipActions;
        this.gds = gds;
    }

    @Override
    public Statement statement() {
        return this.stmt.get();
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.currentTx.get();
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.gds;
    }

    @Override
    public void assertInUnterminatedTransaction() {
        this.assertInOpenTransaction.apply();
    }

    @Override
    public void failTransaction() {
        this.currentTx.get().failure();
    }

    @Override
    public Relationship newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipProxy(this.relationshipActions, id, startNodeId, typeId, endNodeId);
    }
}

