/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.explicitindex;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.explicitindex.AutoIndexOperations;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexOperations;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;

public class InternalAutoIndexing
implements AutoIndexing {
    public static final String NODE_AUTO_INDEX = "node_auto_index";
    public static final String RELATIONSHIP_AUTO_INDEX = "relationship_auto_index";
    private final InternalAutoIndexOperations nodes;
    private final InternalAutoIndexOperations relationships;

    public InternalAutoIndexing(Config config, PropertyKeyTokenHolder propertyKeyLookup) {
        this.nodes = new InternalAutoIndexOperations(propertyKeyLookup, InternalAutoIndexOperations.EntityType.NODE);
        this.relationships = new InternalAutoIndexOperations(propertyKeyLookup, InternalAutoIndexOperations.EntityType.RELATIONSHIP);
        this.nodes.enabled(config.get(GraphDatabaseSettings.node_auto_indexing));
        this.nodes.replacePropertyKeysToInclude(config.get(GraphDatabaseSettings.node_keys_indexable));
        this.relationships.enabled(config.get(GraphDatabaseSettings.relationship_auto_indexing));
        this.relationships.replacePropertyKeysToInclude(config.get(GraphDatabaseSettings.relationship_keys_indexable));
    }

    @Override
    public AutoIndexOperations nodes() {
        return this.nodes;
    }

    @Override
    public AutoIndexOperations relationships() {
        return this.relationships;
    }
}

