/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.storageengine.api.StorageCommand;

public class CachingExplicitIndexTransactionState
implements ExplicitIndexTransactionState {
    private Map<String, ExplicitIndex> nodeExplicitIndexChanges;
    private Map<String, ExplicitIndex> relationshipExplicitIndexChanges;
    private final ExplicitIndexTransactionState txState;

    public CachingExplicitIndexTransactionState(ExplicitIndexTransactionState txState) {
        this.txState = txState;
    }

    @Override
    public ExplicitIndex nodeChanges(String indexName) throws ExplicitIndexNotFoundKernelException {
        ExplicitIndex changes;
        if (this.nodeExplicitIndexChanges == null) {
            this.nodeExplicitIndexChanges = new HashMap<String, ExplicitIndex>();
        }
        if ((changes = this.nodeExplicitIndexChanges.get(indexName)) == null) {
            changes = this.txState.nodeChanges(indexName);
            this.nodeExplicitIndexChanges.put(indexName, changes);
        }
        return changes;
    }

    @Override
    public ExplicitIndex relationshipChanges(String indexName) throws ExplicitIndexNotFoundKernelException {
        ExplicitIndex changes;
        if (this.relationshipExplicitIndexChanges == null) {
            this.relationshipExplicitIndexChanges = new HashMap<String, ExplicitIndex>();
        }
        if ((changes = this.relationshipExplicitIndexChanges.get(indexName)) == null) {
            changes = this.txState.relationshipChanges(indexName);
            this.relationshipExplicitIndexChanges.put(indexName, changes);
        }
        return changes;
    }

    @Override
    public void createIndex(IndexEntityType node, String name, Map<String, String> config) {
        this.txState.createIndex(node, name, config);
    }

    @Override
    public void deleteIndex(IndexEntityType entityType, String indexName) {
        this.txState.deleteIndex(entityType, indexName);
    }

    @Override
    public boolean hasChanges() {
        return this.txState.hasChanges();
    }

    @Override
    public void extractCommands(Collection<StorageCommand> target) throws TransactionFailureException {
        this.txState.extractCommands(target);
    }

    @Override
    public boolean checkIndexExistence(IndexEntityType entityType, String indexName, Map<String, String> config) {
        return this.txState.checkIndexExistence(entityType, indexName, config);
    }
}

