/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.builtinprocs.SchemaProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInProcedures {
    @Context
    public KernelTransaction tx;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graphDatabaseAPI;

    @Description(value="List all labels in the database.")
    @Procedure(name="db.labels", mode=Mode.READ)
    public Stream<LabelResult> listLabels() {
        Statement statement = this.tx.acquireStatement();
        try {
            List labelResults = Iterators.asList((Iterator)TokenAccess.LABELS.inUse(statement).map(x$0 -> new LabelResult((Label)x$0)));
            return labelResults.stream();
        }
        catch (Throwable t) {
            statement.close();
            throw t;
        }
    }

    @Description(value="List all property keys in the database.")
    @Procedure(name="db.propertyKeys", mode=Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        Statement statement = this.tx.acquireStatement();
        try {
            List propertyKeys = Iterators.asList((Iterator)TokenAccess.PROPERTY_KEYS.inUse(statement).map(x$0 -> new PropertyKeyResult((String)x$0)));
            return propertyKeys.stream();
        }
        catch (Throwable t) {
            statement.close();
            throw t;
        }
    }

    @Description(value="List all relationship types in the database.")
    @Procedure(name="db.relationshipTypes", mode=Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        Statement statement = this.tx.acquireStatement();
        try {
            List relationshipTypes = Iterators.asList((Iterator)TokenAccess.RELATIONSHIP_TYPES.inUse(statement).map(x$0 -> new RelationshipTypeResult((RelationshipType)x$0)));
            return relationshipTypes.stream();
        }
        catch (Throwable t) {
            statement.close();
            throw t;
        }
    }

    @Description(value="List all indexes in the database.")
    @Procedure(name="db.indexes", mode=Mode.READ)
    public Stream<IndexResult> listIndexes() throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations operations = statement.readOperations();
            StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
            List indexes = Iterators.asList(operations.indexesGetAll());
            indexes.sort(Comparator.comparing(a -> a.userDescription(tokens)));
            ArrayList<IndexResult> result = new ArrayList<IndexResult>();
            for (IndexDescriptor index : indexes) {
                try {
                    String type = index.type() == IndexDescriptor.Type.UNIQUE ? IndexType.NODE_UNIQUE_PROPERTY.typeName() : IndexType.NODE_LABEL_PROPERTY.typeName();
                    String label = tokens.labelGetName(index.schema().getLabelId());
                    List<String> propertyNames = this.propertyNames(tokens, index);
                    result.add(new IndexResult("INDEX ON " + index.schema().userDescription((TokenNameLookup)tokens), label, propertyNames, operations.indexGetState(index).toString(), type, this.indexProviderDescriptorMap(operations.indexGetProviderDescriptor(index))));
                }
                catch (IndexNotFoundKernelException e) {
                    throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)((Object)e), "No index on ", index.userDescription(tokens));
                }
            }
            Stream stream = result.stream();
            return stream;
        }
    }

    @Description(value="Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\")).")
    @Procedure(name="db.awaitIndex", mode=Mode.READ)
    public void awaitIndex(@Name(value="index") String index, @Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.awaitIndex(index, timeout, TimeUnit.SECONDS);
        }
    }

    @Description(value="Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\")).")
    @Procedure(name="db.awaitIndexes", mode=Mode.READ)
    public void awaitIndexes(@Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        this.graphDatabaseAPI.schema().awaitIndexesOnline(timeout, TimeUnit.SECONDS);
    }

    @Description(value="Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\")).")
    @Procedure(name="db.resampleIndex", mode=Mode.READ)
    public void resampleIndex(@Name(value="index") String index) throws ProcedureException {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.resampleIndex(index);
        }
    }

    @Description(value="Schedule resampling of all outdated indexes.")
    @Procedure(name="db.resampleOutdatedIndexes", mode=Mode.READ)
    public void resampleOutdatedIndexes() {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.resampleOutdatedIndexes();
        }
    }

    @Description(value="Show the schema of the data.")
    @Procedure(name="db.schema", mode=Mode.READ)
    public Stream<SchemaProcedure.GraphResult> metaGraph() throws ProcedureException {
        return Stream.of(new SchemaProcedure(this.graphDatabaseAPI, this.tx).buildSchemaGraph());
    }

    @Description(value="List all constraints in the database.")
    @Procedure(name="db.constraints", mode=Mode.READ)
    public Stream<ConstraintResult> listConstraints() {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations operations = statement.readOperations();
            StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
            Stream<ConstraintResult> stream = Iterators.asList(operations.constraintsGetAll()).stream().map(constraint -> constraint.prettyPrint(tokens)).sorted().map(x$0 -> new ConstraintResult((String)x$0));
            return stream;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get node from explicit index. Replaces `START n=node:nodes(key = 'A')`")
    @Procedure(name="db.index.explicit.seekNodes", mode=Mode.READ)
    public Stream<NodeResult> nodeManualIndexSeek(@Name(value="indexName") String explicitIndexName, @Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.nodeExplicitIndexGet(explicitIndexName, key, value);
            Stream<NodeResult> stream = this.toStream(hits, id -> new NodeResult(this.graphDatabaseAPI.getNodeById(id)));
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Node index %s not found", explicitIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search nodes in explicit index. Replaces `START n=node:nodes('key:foo*')`")
    @Procedure(name="db.index.explicit.searchNodes", mode=Mode.READ)
    public Stream<WeightedNodeResult> nodeManualIndexSearch(@Name(value="indexName") String manualIndexName, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.nodeExplicitIndexQuery(manualIndexName, query);
            Stream<WeightedNodeResult> stream = this.toWeightedNodeResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Node index %s not found", manualIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get relationship from explicit index. Replaces `START r=relationship:relIndex(key = 'A')`")
    @Procedure(name="db.index.explicit.seekRelationships", mode=Mode.READ)
    public Stream<RelationshipResult> relationshipManualIndexSeek(@Name(value="indexName") String manualIndexName, @Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexGet(manualIndexName, key, value, -1L, -1L);
            Stream<RelationshipResult> stream = this.toStream(hits, id -> new RelationshipResult(this.graphDatabaseAPI.getRelationshipById(id)));
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", manualIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship in explicit index. Replaces `START r=relationship:relIndex('key:foo*')`")
    @Procedure(name="db.index.explicit.searchRelationships", mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationshipManualIndexSearch(@Name(value="indexName") String manualIndexName, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexQuery(manualIndexName, query, -1L, -1L);
            Stream<WeightedRelationshipResult> stream = this.toWeightedRelationshipResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", manualIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship in explicit index, starting at the node 'in'.")
    @Procedure(name="db.index.explicit.searchRelationshipsIn", mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationshipManualIndexSearchWithBoundStartNode(@Name(value="indexName") String indexName, @Name(value="in") Node in, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexQuery(indexName, query, in.getId(), -1L);
            Stream<WeightedRelationshipResult> stream = this.toWeightedRelationshipResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", indexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship in explicit index, ending at the node 'out'.")
    @Procedure(name="db.index.explicit.searchRelationshipsOut", mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationshipManualIndexSearchWithBoundEndNode(@Name(value="indexName") String indexName, @Name(value="out") Node out, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexQuery(indexName, query, -1L, out.getId());
            Stream<WeightedRelationshipResult> stream = this.toWeightedRelationshipResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", indexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship in explicit index, starting at the node 'in' and ending at 'out'.")
    @Procedure(name="db.index.explicit.searchRelationshipsBetween", mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationshipManualIndexSearchWithBoundNodes(@Name(value="indexName") String indexName, @Name(value="in") Node in, @Name(value="out") Node out, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexQuery(indexName, query, in.getId(), out.getId());
            Stream<WeightedRelationshipResult> stream = this.toWeightedRelationshipResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", indexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get node from explicit automatic index. Replaces `START n=node:node_auto_index(key = 'A')`")
    @Procedure(name="db.index.explicit.auto.seekNodes", mode=Mode.READ)
    public Stream<NodeResult> nodeAutoIndexSeek(@Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.nodeExplicitIndexGet("node_auto_index", key, value);
            Stream<NodeResult> stream = this.toStream(hits, id -> new NodeResult(this.graphDatabaseAPI.getNodeById(id)));
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return Stream.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search nodes in explicit automatic index. Replaces `START n=node:node_auto_index('key:foo*')`")
    @Procedure(name="db.index.explicit.auto.searchNodes", mode=Mode.READ)
    public Stream<WeightedNodeResult> nodeAutoIndexSearch(@Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.nodeExplicitIndexQuery("node_auto_index", query);
            Stream<WeightedNodeResult> stream = this.toWeightedNodeResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return Stream.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get relationship from explicit automatic index. Replaces `START r=relationship:relationship_auto_index(key = 'A')`")
    @Procedure(name="db.index.explicit.auto.seekRelationships", mode=Mode.READ)
    public Stream<RelationshipResult> relationshipAutoIndexSeek(@Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexGet("relationship_auto_index", key, value, -1L, -1L);
            Stream<RelationshipResult> stream = this.toStream(hits, id -> new RelationshipResult(this.graphDatabaseAPI.getRelationshipById(id)));
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return Stream.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship in explicit automatic index. Replaces `START r=relationship:relationship_auto_index('key:foo*')`")
    @Procedure(name="db.index.explicit.auto.searchRelationships", mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationshipAutoIndexSearch(@Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            ExplicitIndexHits hits = readOperations.relationshipExplicitIndexQuery("relationship_auto_index", query, -1L, -1L);
            Stream<WeightedRelationshipResult> stream = this.toWeightedRelationshipResultStream(hits);
            return stream;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return Stream.empty();
        }
    }

    @Description(value="Get or create a node explicit index - YIELD type,name,config")
    @Procedure(name="db.index.explicit.forNodes", mode=Mode.WRITE)
    public Stream<ExplicitIndexInfo> nodeManualIndex(@Name(value="indexName") String explicitIndexName, @Name(value="config", defaultValue="") Map<String, String> config) {
        IndexManager mgr = this.graphDatabaseAPI.index();
        Index index = config.isEmpty() ? mgr.forNodes(explicitIndexName) : mgr.forNodes(explicitIndexName, config);
        return Stream.of(new ExplicitIndexInfo("NODE", explicitIndexName, mgr.getConfiguration(index)));
    }

    @Description(value="Get or create a relationship explicit index - YIELD type,name,config")
    @Procedure(name="db.index.explicit.forRelationships", mode=Mode.WRITE)
    public Stream<ExplicitIndexInfo> relationshipManualIndex(@Name(value="indexName") String explicitIndexName, @Name(value="config", defaultValue="") Map<String, String> config) {
        IndexManager mgr = this.graphDatabaseAPI.index();
        RelationshipIndex index = config.isEmpty() ? mgr.forRelationships(explicitIndexName) : mgr.forRelationships(explicitIndexName, config);
        return Stream.of(new ExplicitIndexInfo("RELATIONSHIP", explicitIndexName, mgr.getConfiguration((Index)index)));
    }

    @Description(value="Check if a node explicit index exists")
    @Procedure(name="db.index.explicit.existsForNodes", mode=Mode.READ)
    public Stream<BooleanResult> nodeManualIndexExists(@Name(value="indexName") String explicitIndexName) {
        return Stream.of(new BooleanResult(this.graphDatabaseAPI.index().existsForNodes(explicitIndexName)));
    }

    @Description(value="Check if a relationship explicit index exists")
    @Procedure(value="db.index.explicit.existsForRelationships")
    public Stream<BooleanResult> relationshipManualIndexExists(@Name(value="indexName") String explicitIndexName) {
        return Stream.of(new BooleanResult(this.graphDatabaseAPI.index().existsForRelationships(explicitIndexName)));
    }

    @Description(value="List all explicit indexes - YIELD type,name,config")
    @Procedure(name="db.index.explicit.list", mode=Mode.READ)
    public Stream<ExplicitIndexInfo> list() {
        Index index;
        IndexManager mgr = this.graphDatabaseAPI.index();
        ArrayList<ExplicitIndexInfo> indexInfos = new ArrayList<ExplicitIndexInfo>(100);
        for (String name : mgr.nodeIndexNames()) {
            index = mgr.forNodes(name);
            indexInfos.add(new ExplicitIndexInfo("NODE", name, mgr.getConfiguration(index)));
        }
        for (String name : mgr.relationshipIndexNames()) {
            index = mgr.forRelationships(name);
            indexInfos.add(new ExplicitIndexInfo("RELATIONSHIP", name, mgr.getConfiguration(index)));
        }
        return indexInfos.stream();
    }

    @Description(value="Remove an explicit index - YIELD type,name,config")
    @Procedure(name="db.index.explicit.drop", mode=Mode.WRITE)
    public Stream<ExplicitIndexInfo> manualIndexDrop(@Name(value="indexName") String explicitIndexName) {
        Index index;
        IndexManager mgr = this.graphDatabaseAPI.index();
        ArrayList<ExplicitIndexInfo> results = new ArrayList<ExplicitIndexInfo>(2);
        if (mgr.existsForNodes(explicitIndexName)) {
            index = mgr.forNodes(explicitIndexName);
            results.add(new ExplicitIndexInfo("NODE", explicitIndexName, mgr.getConfiguration(index)));
            index.delete();
        }
        if (mgr.existsForRelationships(explicitIndexName)) {
            index = mgr.forRelationships(explicitIndexName);
            results.add(new ExplicitIndexInfo("RELATIONSHIP", explicitIndexName, mgr.getConfiguration(index)));
            index.delete();
        }
        return results.stream();
    }

    @Description(value="Add a node to an explicit index based on a specified key and value")
    @Procedure(name="db.index.explicit.addNode", mode=Mode.WRITE)
    public Stream<BooleanResult> nodeManualIndexAdd(@Name(value="indexName") String explicitIndexName, @Name(value="node") Node node, @Name(value="key") String key, @Name(value="value") Object value) {
        this.graphDatabaseAPI.index().forNodes(explicitIndexName).add((PropertyContainer)node, key, value);
        return Stream.of(new BooleanResult(true));
    }

    @Description(value="Add a relationship to an explicit index based on a specified key and value")
    @Procedure(name="db.index.explicit.addRelationship", mode=Mode.WRITE)
    public Stream<BooleanResult> relationshipManualIndexAdd(@Name(value="indexName") String explicitIndexName, @Name(value="relationship") Relationship relationship, @Name(value="key") String key, @Name(value="value") Object value) {
        this.graphDatabaseAPI.index().forRelationships(explicitIndexName).add((PropertyContainer)relationship, key, value);
        return Stream.of(new BooleanResult(true));
    }

    @Description(value="Remove a node from an explicit index with an optional key")
    @Procedure(name="db.index.explicit.removeNode", mode=Mode.WRITE)
    public Stream<BooleanResult> nodeManualIndexRemove(@Name(value="indexName") String explicitIndexName, @Name(value="node") Node node, @Name(value="key") String key) {
        if (key.equals(" <[6795b15e-8693-4a21-b57a-4a7b87f09a5a]> ")) {
            this.graphDatabaseAPI.index().forNodes(explicitIndexName).remove((PropertyContainer)node);
        } else {
            this.graphDatabaseAPI.index().forNodes(explicitIndexName).remove((PropertyContainer)node, key);
        }
        return Stream.of(new BooleanResult(true));
    }

    @Description(value="Remove a relationship from an explicit index with an optional key")
    @Procedure(name="db.index.explicit.removeRelationship", mode=Mode.WRITE)
    public Stream<BooleanResult> relationshipManualIndexRemove(@Name(value="indexName") String explicitIndexName, @Name(value="relationship") Relationship relationship, @Name(value="key") String key) {
        if (key.equals(" <[6795b15e-8693-4a21-b57a-4a7b87f09a5a]> ")) {
            this.graphDatabaseAPI.index().forRelationships(explicitIndexName).remove((PropertyContainer)relationship);
        } else {
            this.graphDatabaseAPI.index().forRelationships(explicitIndexName).remove((PropertyContainer)relationship, key);
        }
        return Stream.of(new BooleanResult(true));
    }

    private Map<String, String> indexProviderDescriptorMap(SchemaIndexProvider.Descriptor providerDescriptor) {
        return MapUtil.stringMap((String[])new String[]{"key", providerDescriptor.getKey(), "version", providerDescriptor.getVersion()});
    }

    private List<String> propertyNames(TokenNameLookup tokens, IndexDescriptor index) {
        int[] propertyIds = index.schema().getPropertyIds();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (int i = 0; i < propertyIds.length; ++i) {
            propertyNames.add(tokens.propertyKeyGetName(propertyIds[i]));
        }
        return propertyNames;
    }

    private <T> Stream<T> toStream(final PrimitiveLongResourceIterator iterator, final LongFunction<T> mapper) {
        Iterator it = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return mapper.apply(iterator.next());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private Stream<WeightedNodeResult> toWeightedNodeResultStream(final ExplicitIndexHits iterator) {
        Iterator<WeightedNodeResult> it = new Iterator<WeightedNodeResult>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public WeightedNodeResult next() {
                return new WeightedNodeResult(BuiltInProcedures.this.graphDatabaseAPI.getNodeById(iterator.next()), iterator.currentScore());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private Stream<WeightedRelationshipResult> toWeightedRelationshipResultStream(final ExplicitIndexHits iterator) {
        Iterator<WeightedRelationshipResult> it = new Iterator<WeightedRelationshipResult>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public WeightedRelationshipResult next() {
                return new WeightedRelationshipResult(BuiltInProcedures.this.graphDatabaseAPI.getRelationshipById(iterator.next()), iterator.currentScore());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private IndexProcedures indexProcedures() {
        return new IndexProcedures(this.tx, (IndexingService)this.resolver.resolveDependency(IndexingService.class));
    }

    private static enum IndexType {
        NODE_LABEL_PROPERTY("node_label_property"),
        NODE_UNIQUE_PROPERTY("node_unique_property");

        private final String typeName;

        private IndexType(String typeName) {
            this.typeName = typeName;
        }

        public String typeName() {
            return this.typeName;
        }
    }

    public class RelationshipResult {
        public final Relationship relationship;

        public RelationshipResult(Relationship relationship) {
            this.relationship = relationship;
        }
    }

    public class WeightedRelationshipResult {
        public final Relationship relationship;
        public final double weight;

        public WeightedRelationshipResult(Relationship relationship, double weight) {
            this.relationship = relationship;
            this.weight = weight;
        }
    }

    public class WeightedNodeResult {
        public final Node node;
        public final double weight;

        public WeightedNodeResult(Node node, double weight) {
            this.node = node;
            this.weight = weight;
        }
    }

    public class NodeResult {
        public final Node node;

        public NodeResult(Node node) {
            this.node = node;
        }
    }

    public class ConstraintResult {
        public final String description;

        private ConstraintResult(String description) {
            this.description = description;
        }
    }

    public static class ExplicitIndexInfo {
        public final String type;
        public final String name;
        public final Map<String, String> config;

        public ExplicitIndexInfo(String type, String name, Map<String, String> config) {
            this.type = type;
            this.name = name;
            this.config = config;
        }
    }

    public class IndexResult {
        public final String description;
        public final String label;
        public final List<String> properties;
        public final String state;
        public final String type;
        public final Map<String, String> provider;

        private IndexResult(String description, String label, List<String> properties, String state, String type, Map<String, String> provider) {
            this.description = description;
            this.label = label;
            this.properties = properties;
            this.state = state;
            this.type = type;
            this.provider = provider;
        }
    }

    public class BooleanResult {
        public final Boolean success;

        public BooleanResult(Boolean success) {
            this.success = success;
        }
    }

    public class RelationshipTypeResult {
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public class PropertyKeyResult {
        public final String propertyKey;

        private PropertyKeyResult(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public class LabelResult {
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }
}

