/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;

public class RepeatedPropertyInCompositeSchemaException
extends SchemaKernelException {
    private final SchemaDescriptor schema;
    private final SchemaKernelException.OperationContext context;

    public RepeatedPropertyInCompositeSchemaException(SchemaDescriptor schema, SchemaKernelException.OperationContext context) {
        super((Status)Status.Schema.RepeatedPropertyInCompositeSchema, RepeatedPropertyInCompositeSchemaException.format(schema, context, SchemaUtil.idTokenNameLookup));
        this.schema = schema;
        this.context = context;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return RepeatedPropertyInCompositeSchemaException.format(this.schema, this.context, tokenNameLookup);
    }

    private static String format(SchemaDescriptor schema, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        String schemaName;
        switch (context) {
            case INDEX_CREATION: {
                schemaName = "Index";
                break;
            }
            case CONSTRAINT_CREATION: {
                schemaName = "Constraint";
                break;
            }
            default: {
                schemaName = "Schema object";
            }
        }
        return String.format("%s on %s includes a property more than once.", schemaName, schema.userDescription(tokenNameLookup));
    }
}

