/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.diagnostics;

import java.io.PrintStream;
import org.neo4j.diagnostics.DiagnosticsReporterProgressCallback;

public class NonInteractiveProgress
implements DiagnosticsReporterProgressCallback {
    private String totalSteps = "?";
    private final PrintStream out;
    private final boolean verbose;
    private int lastPercentage;

    public NonInteractiveProgress(PrintStream out, boolean verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    @Override
    public void percentChanged(int percent) {
        for (int i = this.lastPercentage + 1; i <= percent; ++i) {
            this.out.print('.');
            if (i % 20 != 0) continue;
            this.out.printf(" %3d%%%n", i);
        }
        this.lastPercentage = percent;
        this.out.flush();
    }

    @Override
    public void started(long currentStepIndex, String target) {
        this.out.println(currentStepIndex + "/" + this.totalSteps + " " + target);
        this.lastPercentage = 0;
    }

    @Override
    public void finished() {
        this.percentChanged(100);
        this.out.println();
    }

    @Override
    public void info(String info) {
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.out.println();
        this.out.println("Error: " + msg);
        if (this.verbose) {
            throwable.printStackTrace(this.out);
        }
    }

    @Override
    public void setTotalSteps(long steps) {
        this.totalSteps = String.valueOf(steps);
    }
}

