/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;

public class Stage {
    private final List<Step<?>> pipeline = new ArrayList();
    private final StageExecution execution;

    public Stage(String name, String part, Configuration config, int orderingGuarantees) {
        this.execution = new StageExecution(name, part, config, this.pipeline, orderingGuarantees);
    }

    protected StageControl control() {
        return this.execution;
    }

    public void add(Step<?> step) {
        this.pipeline.add(step);
    }

    public StageExecution execute() {
        this.linkSteps();
        this.execution.start();
        this.pipeline.get(0).receive(1L, null);
        return this.execution;
    }

    private void linkSteps() {
        Step<?> previous = null;
        for (Step<?> step : this.pipeline) {
            if (previous != null) {
                previous.setDownstream(step);
            }
            previous = step;
        }
    }

    public void close() {
        Exception exception = null;
        for (Step<?> step : this.pipeline) {
            try {
                step.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw Exceptions.launderedException(exception);
        }
    }
}

