/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Predicate;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkingProgress;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeType;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class RelationshipLinkStep
extends ForkedProcessorStep<RelationshipRecord[]> {
    protected final NodeRelationshipCache cache;
    private final int nodeTypes;
    private final Predicate<RelationshipRecord> filter;
    private final boolean forwards;
    private final RelationshipLinkingProgress progress;

    public RelationshipLinkStep(StageControl control, Configuration config, NodeRelationshipCache cache, Predicate<RelationshipRecord> filter, int nodeTypes, boolean forwards, StatsProvider ... additionalStatsProvider) {
        super(control, "LINK", config, additionalStatsProvider);
        this.cache = cache;
        this.filter = filter;
        this.nodeTypes = nodeTypes;
        this.forwards = forwards;
        this.progress = this.findLinkingProgressStatsProvider();
    }

    private RelationshipLinkingProgress findLinkingProgressStatsProvider() {
        for (StatsProvider provider : this.additionalStatsProvider) {
            if (!(provider instanceof RelationshipLinkingProgress)) continue;
            return (RelationshipLinkingProgress)provider;
        }
        throw new IllegalStateException("Expected to have a specific stats provider about progress");
    }

    @Override
    protected void forkedProcess(int id, int processors, RelationshipRecord[] batch) {
        int stride = this.forwards ? 1 : -1;
        int start = this.forwards ? 0 : batch.length - 1;
        int end = this.forwards ? batch.length : -1;
        int localChangeCount = 0;
        for (int i = start; i != end; i += stride) {
            RelationshipRecord item = batch[i];
            if (item == null || !item.inUse()) continue;
            int changeCount = this.process(item, id, processors);
            if (changeCount == -1) {
                batch[i] = null;
                continue;
            }
            localChangeCount += changeCount;
        }
        this.progress.add(localChangeCount);
    }

    public int process(RelationshipRecord record, int id, int processors) {
        boolean isLoop;
        long startNode = record.getFirstNode();
        long endNode = record.getSecondNode();
        boolean processFirst = startNode % (long)processors == (long)id;
        boolean processSecond = endNode % (long)processors == (long)id;
        int changeCount = 0;
        if (!processFirst && !processSecond) {
            return changeCount;
        }
        boolean firstIsDense = this.cache.isDense(startNode);
        boolean changed = false;
        boolean bl = isLoop = startNode == endNode;
        if (isLoop) {
            if (this.shouldChange(firstIsDense, record)) {
                if (processFirst) {
                    this.linkLoop(record);
                    changeCount += 2;
                }
                changed = true;
            }
        } else {
            boolean secondIsDense;
            if (this.shouldChange(firstIsDense, record)) {
                if (processFirst) {
                    this.linkStart(record);
                    ++changeCount;
                }
                changed = true;
            }
            if (this.shouldChange(secondIsDense = this.cache.isDense(endNode), record)) {
                if (processSecond) {
                    this.linkEnd(record);
                    ++changeCount;
                }
                changed = true;
            }
        }
        return changed ? changeCount : -1;
    }

    protected abstract void linkStart(RelationshipRecord var1);

    protected abstract void linkEnd(RelationshipRecord var1);

    protected abstract void linkLoop(RelationshipRecord var1);

    private boolean shouldChange(boolean isDense, RelationshipRecord record) {
        if (!NodeType.matchesDense(this.nodeTypes, isDense)) {
            return false;
        }
        return !isDense || this.filter == null || this.filter.test(record);
    }
}

