/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.id.RenewableBatchIdSequence;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.ReusableIteratorCostume;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, RECORD>> {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder;
    private final ThreadLocal<IdBatches> ids;
    private final PropertyStore propertyStore;

    protected PropertyEncoderStep(StageControl control, Configuration config, BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder, final PropertyStore propertyStore) {
        super(control, "PROPERTIES", config, 0, new StatsProvider[0]);
        this.propertyKeyHolder = propertyKeyHolder;
        this.propertyStore = propertyStore;
        this.ids = new ThreadLocal<IdBatches>(){

            @Override
            protected IdBatches initialValue() {
                return new IdBatches(propertyStore);
            }
        };
    }

    @Override
    protected void process(Batch<INPUT, RECORD> batch, BatchSender sender) {
        IdBatches threadIds = this.ids.get();
        PropertyCreator propertyCreator = new PropertyCreator(threadIds.stringIds, threadIds.arrayIds, threadIds.propertyIds, null, this.propertyStore.allowStorePoints());
        ArrayCollection propertyRecordCollection = new ArrayCollection(4);
        BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
        ReusableIteratorCostume<PropertyBlock> blockIterator = new ReusableIteratorCostume<PropertyBlock>();
        batch.propertyRecords = new PropertyRecord[((InputEntity[])batch.input).length][];
        int totalNumberOfProperties = 0;
        for (int i = 0; i < ((InputEntity[])batch.input).length; ++i) {
            int count;
            InputEntity input = ((InputEntity[])batch.input)[i];
            if (input.hasFirstPropertyId() || (count = input.propertyCount()) <= 0) continue;
            PropertyBlock[] propertyBlocks = new PropertyBlock[count];
            this.propertyKeyHolder.propertyKeysAndValues(propertyBlocks, 0, input.properties(), propertyCreator);
            propertyCreator.createPropertyChain(null, blockIterator.dressArray(propertyBlocks, 0, count), propertyRecords, propertyRecordCollection::add);
            batch.propertyRecords[i] = propertyRecordCollection.toArray((R[])new PropertyRecord[propertyRecordCollection.size()]);
            ((PrimitiveRecord)batch.records[i]).setNextProp(batch.propertyRecords[i][0].getId());
            ((PrimitiveRecord)batch.records[i]).setIdTo(batch.propertyRecords[i][0]);
            totalNumberOfProperties += count;
            propertyRecordCollection.clear();
        }
        batch.numberOfProperties = totalNumberOfProperties;
        sender.send(batch);
    }

    private static class IdBatches {
        final RenewableBatchIdSequence propertyIds;
        final DynamicRecordAllocator stringIds;
        final DynamicRecordAllocator arrayIds;

        IdBatches(PropertyStore propertyStore) {
            this.propertyIds = new RenewableBatchIdSequence(propertyStore, propertyStore.getRecordsPerPage(), id -> {});
            this.stringIds = new StandardDynamicRecordAllocator(new RenewableBatchIdSequence(propertyStore.getStringStore(), propertyStore.getStringStore().getRecordsPerPage(), id -> {}), propertyStore.getStringStore().getRecordDataSize());
            this.arrayIds = new StandardDynamicRecordAllocator(new RenewableBatchIdSequence(propertyStore.getArrayStore(), propertyStore.getArrayStore().getRecordsPerPage(), id -> {}), propertyStore.getArrayStore().getRecordDataSize());
        }
    }
}

