/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.LongFunction;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class EntityStoreUpdaterStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, RECORD>> {
    private final CommonAbstractStore<RECORD, ? extends StoreHeader> entityStore;
    private final PropertyStore propertyStore;
    private final IoMonitor ioMonitor;
    private final Monitor monitor;
    private final PrepareIdSequence prepareIdSequence;

    EntityStoreUpdaterStep(StageControl control, Configuration config, CommonAbstractStore<RECORD, ? extends StoreHeader> entityStore, PropertyStore propertyStore, IoMonitor ioMonitor, Monitor monitor, PrepareIdSequence prepareIdSequence) {
        super(control, "v", config, config.parallelRecordWrites() ? 0 : 1, ioMonitor);
        this.entityStore = entityStore;
        this.propertyStore = propertyStore;
        this.monitor = monitor;
        this.ioMonitor = ioMonitor;
        this.prepareIdSequence = prepareIdSequence;
        this.ioMonitor.reset();
    }

    @Override
    protected void process(Batch<INPUT, RECORD> batch, BatchSender sender) {
        LongFunction idSequence = (LongFunction)this.prepareIdSequence.apply(this.entityStore);
        long highestId = 0L;
        RECORD[] records = batch.records;
        if (records.length == 0) {
            return;
        }
        int skipped = 0;
        for (Object record : records) {
            if (record != null && ((AbstractBaseRecord)record).inUse()) {
                highestId = Math.max(highestId, ((AbstractBaseRecord)record).getId());
                this.entityStore.prepareForCommit(record, (IdSequence)idSequence.apply(((AbstractBaseRecord)record).getId()));
                this.entityStore.updateRecord(record);
                continue;
            }
            ++skipped;
        }
        EntityStoreUpdaterStep.writePropertyRecords(batch.propertyRecords, this.propertyStore);
        this.monitor.entitiesWritten(records[0].getClass(), records.length - skipped);
        this.monitor.propertiesWritten(batch.numberOfProperties);
    }

    static void writePropertyRecords(PropertyRecord[][] batch, PropertyStore propertyStore) {
        for (PropertyRecord[] propertyRecords : batch) {
            if (propertyRecords == null) continue;
            for (PropertyRecord propertyRecord : propertyRecords) {
                propertyStore.prepareForCommit(propertyRecord);
                propertyStore.updateRecord(propertyRecord);
            }
        }
    }

    @Override
    protected void done() {
        super.done();
        this.ioMonitor.stop();
    }

    public static interface Monitor {
        public void entitiesWritten(Class<? extends PrimitiveRecord> var1, long var2);

        public void propertiesWritten(long var1);
    }
}

