/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;

public class EagerlyReversedTransactionCursor
implements TransactionCursor {
    private final List<CommittedTransactionRepresentation> txs = new ArrayList<CommittedTransactionRepresentation>();
    private final TransactionCursor cursor;
    private int indexToReturn;

    public EagerlyReversedTransactionCursor(TransactionCursor cursor) throws IOException {
        this.cursor = cursor;
        while (cursor.next()) {
            this.txs.add((CommittedTransactionRepresentation)cursor.get());
        }
        this.indexToReturn = this.txs.size();
    }

    public boolean next() throws IOException {
        if (this.indexToReturn > 0) {
            --this.indexToReturn;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.cursor.close();
    }

    public CommittedTransactionRepresentation get() {
        return this.txs.get(this.indexToReturn);
    }

    @Override
    public LogPosition position() {
        throw new UnsupportedOperationException("Should not be called");
    }

    public static TransactionCursor eagerlyReverse(TransactionCursor cursor) throws IOException {
        return new EagerlyReversedTransactionCursor(cursor);
    }
}

