/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

class NodeValueIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.NodeValueIndexCursor,
IndexProgressor.NodeValueClient {
    private Read read;
    private long node = -1L;
    private int[] keys;
    private Value[] values;

    NodeValueIndexCursor() {
    }

    @Override
    public void initialize(IndexProgressor progressor, int[] propertyIds) {
        super.initialize(progressor);
        this.keys = propertyIds;
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        this.node = reference;
        this.values = values;
        return true;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public int numberOfProperties() {
        return this.keys == null ? 0 : this.keys.length;
    }

    public int propertyKey(int offset) {
        return this.keys[offset];
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public Value propertyValue(int offset) {
        return this.values[offset];
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.keys = null;
        this.values = null;
        this.read = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeValueIndexCursor[closed state]";
        }
        return "NodeValueIndexCursor[node=" + this.node + ", open state with: keys=" + Arrays.toString(this.keys) + ", values=" + Arrays.toString(this.values) + ", underlying record=" + super.toString() + " ]";
    }
}

