/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.newapi.UnionIndexCapability;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class FusionSchemaIndexProvider
extends SchemaIndexProvider {
    private final SchemaIndexProvider nativeProvider;
    private final SchemaIndexProvider luceneProvider;
    private final Selector selector;
    private final DropAction dropAction;

    public FusionSchemaIndexProvider(SchemaIndexProvider nativeProvider, SchemaIndexProvider luceneProvider, Selector selector, SchemaIndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructure, FileSystemAbstraction fs) {
        super(descriptor, priority, directoryStructure);
        this.nativeProvider = nativeProvider;
        this.luceneProvider = luceneProvider;
        this.selector = selector;
        this.dropAction = new FileSystemDropAction(fs, this.directoryStructure());
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new FusionIndexPopulator(this.nativeProvider.getPopulator(indexId, descriptor, samplingConfig), this.luceneProvider.getPopulator(indexId, descriptor, samplingConfig), this.selector, indexId, this.dropAction);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        return new FusionIndexAccessor(this.nativeProvider.getOnlineAccessor(indexId, descriptor, samplingConfig), this.luceneProvider.getOnlineAccessor(indexId, descriptor, samplingConfig), this.selector, indexId, descriptor, this.dropAction);
    }

    @Override
    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String nativeFailure = null;
        try {
            nativeFailure = this.nativeProvider.getPopulationFailure(indexId);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String luceneFailure = null;
        try {
            luceneFailure = this.luceneProvider.getPopulationFailure(indexId);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (nativeFailure != null || luceneFailure != null) {
            return "native: " + nativeFailure + " lucene: " + luceneFailure;
        }
        throw new IllegalStateException("None of the indexes were in a failed state");
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        InternalIndexState nativeState = this.nativeProvider.getInitialState(indexId, descriptor);
        InternalIndexState luceneState = this.luceneProvider.getInitialState(indexId, descriptor);
        if (nativeState == InternalIndexState.FAILED || luceneState == InternalIndexState.FAILED) {
            return InternalIndexState.FAILED;
        }
        if (nativeState == InternalIndexState.POPULATING || luceneState == InternalIndexState.POPULATING) {
            return InternalIndexState.POPULATING;
        }
        return nativeState;
    }

    @Override
    public IndexCapability getCapability(IndexDescriptor indexDescriptor) {
        IndexCapability nativeCapability = this.nativeProvider.getCapability(indexDescriptor);
        IndexCapability luceneCapability = this.luceneProvider.getCapability(indexDescriptor);
        return new UnionIndexCapability(new IndexCapability[]{nativeCapability, luceneCapability}){

            @Override
            public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
                if (valueGroups.length == 1 && valueGroups[0] == ValueGroup.UNKNOWN) {
                    return new IndexOrder[0];
                }
                return super.orderCapability(valueGroups);
            }
        };
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    static IndexSample combineSamples(IndexSample first, IndexSample other) {
        return new IndexSample(first.indexSize() + other.indexSize(), first.uniqueValues() + other.uniqueValues(), first.sampleSize() + other.sampleSize());
    }

    private static class FileSystemDropAction
    implements DropAction {
        private final FileSystemAbstraction fs;
        private final IndexDirectoryStructure directoryStructure;

        FileSystemDropAction(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
            this.fs = fs;
            this.directoryStructure = directoryStructure;
        }

        @Override
        public void drop(long indexId) throws IOException {
            this.fs.deleteRecursively(this.directoryStructure.directoryForIndex(indexId));
        }
    }

    @FunctionalInterface
    static interface DropAction {
        public void drop(long var1) throws IOException;
    }

    public static interface Selector {
        public <T> T select(T var1, T var2, Value ... var3);
    }
}

