/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TxStateTransactionDataSnapshot
implements TransactionData {
    private final ReadableTransactionState state;
    private final NodeProxy.NodeActions nodeActions;
    private final StorageStatement storeStatement;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final StoreReadLayer store;
    private KernelTransaction transaction;
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> assignedLabels = new ArrayList<LabelEntry>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> removedLabels = new ArrayList<LabelEntry>();
    private final PrimitiveLongObjectMap<RelationshipProxy> relationshipsReadFromStore = Primitive.longObjectMap((int)16);

    public TxStateTransactionDataSnapshot(ReadableTransactionState state, NodeProxy.NodeActions nodeActions, RelationshipProxy.RelationshipActions relationshipActions, StoreReadLayer storeReadLayer, StorageStatement storageStatement, KernelTransaction transaction) {
        this.state = state;
        this.nodeActions = nodeActions;
        this.relationshipActions = relationshipActions;
        this.storeStatement = storageStatement;
        this.store = storeReadLayer;
        this.transaction = transaction;
        this.takeSnapshot();
    }

    public Iterable<Node> createdNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getAdded());
    }

    public Iterable<Node> deletedNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getRemoved());
    }

    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getAdded());
    }

    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getRemoved());
    }

    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    public String username() {
        return this.transaction.securityContext().subject().username();
    }

    public Map<String, Object> metaData() {
        if (this.transaction instanceof KernelTransactionImplementation) {
            return ((KernelTransactionImplementation)this.transaction).getMetaData();
        }
        return Collections.emptyMap();
    }

    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    public long getTransactionId() {
        return this.transaction.getTransactionId();
    }

    public long getCommitTime() {
        return this.transaction.getCommitTime();
    }

    private void takeSnapshot() {
        try {
            Object property;
            Iterator lock2;
            Iterator<Object> iterator = this.state.addedAndRemovedNodes().getRemoved().iterator();
            while (iterator.hasNext()) {
                long nodeId = (Long)iterator.next();
                Cursor<NodeItem> node = this.storeStatement.acquireSingleNodeCursor(nodeId);
                Throwable throwable = null;
                try {
                    if (!node.next()) continue;
                    lock2 = ((NodeItem)node.get()).lock();
                    try (Cursor<PropertyItem> properties = this.storeStatement.acquirePropertyCursor(((NodeItem)node.get()).nextPropertyId(), (Lock)((Object)lock2), AssertOpen.ALWAYS_OPEN);){
                        while (properties.next()) {
                            this.removedNodeProperties.add(new NodePropertyEntryView(nodeId, this.store.propertyKeyGetName(((PropertyItem)properties.get()).propertyKeyId()), null, ((PropertyItem)properties.get()).value()));
                        }
                    }
                    ((NodeItem)node.get()).labels().visitKeys(labelId -> {
                        this.removedLabels.add(new LabelEntryView(nodeId, this.store.labelGetName(labelId)));
                        return false;
                    });
                }
                catch (Throwable lock2) {
                    throwable = lock2;
                    throw lock2;
                }
                finally {
                    if (node == null) continue;
                    if (throwable != null) {
                        try {
                            node.close();
                        }
                        catch (Throwable lock2) {
                            throwable.addSuppressed(lock2);
                        }
                        continue;
                    }
                    node.close();
                }
            }
            iterator = this.state.addedAndRemovedRelationships().getRemoved().iterator();
            while (iterator.hasNext()) {
                long relId = (Long)iterator.next();
                Relationship relationshipProxy = this.relationship(relId);
                Cursor<RelationshipItem> relationship = this.storeStatement.acquireSingleRelationshipCursor(relId);
                lock2 = null;
                try {
                    if (!relationship.next()) continue;
                    Lock lock3 = ((RelationshipItem)relationship.get()).lock();
                    Cursor<PropertyItem> properties = this.storeStatement.acquirePropertyCursor(((RelationshipItem)relationship.get()).nextPropertyId(), lock3, AssertOpen.ALWAYS_OPEN);
                    Throwable throwable = null;
                    try {
                        while (properties.next()) {
                            this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationshipProxy, this.store.propertyKeyGetName(((PropertyItem)properties.get()).propertyKeyId()), null, ((PropertyItem)properties.get()).value()));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (properties == null) continue;
                        if (throwable != null) {
                            try {
                                properties.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        properties.close();
                    }
                }
                catch (Throwable lock3) {
                    lock2 = lock3;
                    throw lock3;
                }
                finally {
                    if (relationship == null) continue;
                    if (lock2 != null) {
                        try {
                            relationship.close();
                        }
                        catch (Throwable lock3) {
                            ((Throwable)((Object)lock2)).addSuppressed(lock3);
                        }
                        continue;
                    }
                    relationship.close();
                }
            }
            for (NodeState nodeState : this.state.modifiedNodes()) {
                Iterator<StorageProperty> added = nodeState.addedAndChangedProperties();
                while (added.hasNext()) {
                    StorageProperty property2 = added.next();
                    this.assignedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName(property2.propertyKeyId()), property2.value(), this.committedValue(nodeState, property2.propertyKeyId())));
                }
                Iterator<Integer> removed = nodeState.removedProperties();
                while (removed.hasNext()) {
                    property = removed.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName((Integer)property), null, this.committedValue(nodeState, ((Integer)property).intValue())));
                }
                ReadableDiffSets<Integer> labels = nodeState.labelDiffSets();
                for (Integer label : labels.getAdded()) {
                    this.assignedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
                for (Integer label : labels.getRemoved()) {
                    this.removedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
            }
            for (RelationshipState relState : this.state.modifiedRelationships()) {
                Relationship relationship = this.relationship(relState.getId());
                Iterator<StorageProperty> added = relState.addedAndChangedProperties();
                while (added.hasNext()) {
                    property = added.next();
                    this.assignedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(property.propertyKeyId()), property.value(), this.committedValue(relState, property.propertyKeyId())));
                }
                Iterator<Integer> removed = relState.removedProperties();
                while (removed.hasNext()) {
                    Integer property3 = removed.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(property3), null, this.committedValue(relState, (int)property3)));
                }
            }
        }
        catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("An entity that does not exist was modified.", e);
        }
    }

    private Relationship relationship(long relId) {
        RelationshipProxy relationship = new RelationshipProxy(this.relationshipActions, relId);
        if (!this.state.relationshipVisit(relId, relationship)) {
            RelationshipProxy cached = (RelationshipProxy)this.relationshipsReadFromStore.get(relId);
            if (cached != null) {
                return cached;
            }
            try {
                this.store.relationshipVisit(relId, relationship);
                this.relationshipsReadFromStore.put(relId, (Object)relationship);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Getting deleted relationship data should have been covered by the tx state");
            }
        }
        return relationship;
    }

    private Iterable<Node> map2Nodes(Iterable<Long> added) {
        return new IterableWrapper<Node, Long>(added){

            protected Node underlyingObjectToObject(Long id) {
                return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, id);
            }
        };
    }

    private Iterable<Relationship> map2Rels(Iterable<Long> ids) {
        return new IterableWrapper<Relationship, Long>(ids){

            protected Relationship underlyingObjectToObject(Long id) {
                return TxStateTransactionDataSnapshot.this.relationship(id);
            }
        };
    }

    private Value committedValue(NodeState nodeState, int property) {
        if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
            return Values.NO_VALUE;
        }
        try (Cursor<NodeItem> node = this.storeStatement.acquireSingleNodeCursor(nodeState.getId());){
            if (!node.next()) {
                Value value = Values.NO_VALUE;
                return value;
            }
            Lock lock = ((NodeItem)node.get()).lock();
            try (Cursor<PropertyItem> properties = this.storeStatement.acquireSinglePropertyCursor(((NodeItem)node.get()).nextPropertyId(), property, lock, AssertOpen.ALWAYS_OPEN);){
                if (properties.next()) {
                    Value value = ((PropertyItem)properties.get()).value();
                    return value;
                }
            }
        }
        return Values.NO_VALUE;
    }

    private Value committedValue(RelationshipState relState, int property) {
        if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
            return Values.NO_VALUE;
        }
        try (Cursor<RelationshipItem> relationship = this.storeStatement.acquireSingleRelationshipCursor(relState.getId());){
            if (!relationship.next()) {
                Value value = Values.NO_VALUE;
                return value;
            }
            Lock lock = ((RelationshipItem)relationship.get()).lock();
            try (Cursor<PropertyItem> properties = this.storeStatement.acquireSinglePropertyCursor(((RelationshipItem)relationship.get()).nextPropertyId(), property, lock, AssertOpen.ALWAYS_OPEN);){
                if (properties.next()) {
                    Value value = ((PropertyItem)properties.get()).value();
                    return value;
                }
            }
        }
        return Values.NO_VALUE;
    }

    private class LabelEntryView
    implements LabelEntry {
        private final long nodeId;
        private final Label label;

        LabelEntryView(long nodeId, String labelName) {
            this.nodeId = nodeId;
            this.label = Label.label((String)labelName);
        }

        public Label label() {
            return this.label;
        }

        public Node node() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        public String toString() {
            return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + '}';
        }
    }

    private class RelationshipPropertyEntryView
    implements PropertyEntry<Relationship> {
        private final Relationship relationship;
        private final String key;
        private final Value newValue;
        private final Value oldValue;

        RelationshipPropertyEntryView(Relationship relationship, String key, Value newValue, Value oldValue) {
            this.relationship = relationship;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Relationship entity() {
            return this.relationship;
        }

        public String key() {
            return this.key;
        }

        public Object previouslyCommitedValue() {
            return this.oldValue.asObjectCopy();
        }

        public Object value() {
            if (this.newValue == null || this.newValue == Values.NO_VALUE) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue.asObjectCopy();
        }

        public String toString() {
            return "RelationshipPropertyEntryView{relId=" + this.relationship.getId() + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class NodePropertyEntryView
    implements PropertyEntry<Node> {
        private final long nodeId;
        private final String key;
        private final Value newValue;
        private final Value oldValue;

        NodePropertyEntryView(long nodeId, String key, Value newValue, Value oldValue) {
            this.nodeId = nodeId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Node entity() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        public String key() {
            return this.key;
        }

        public Object previouslyCommitedValue() {
            return this.oldValue.asObjectCopy();
        }

        public Object value() {
            if (this.newValue == null || this.newValue == Values.NO_VALUE) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue.asObjectCopy();
        }

        public String toString() {
            return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }
}

