/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipProxy
implements Relationship,
RelationshipVisitor<RuntimeException> {
    private final RelationshipActions actions;
    private long id = -1L;
    private long startNode = -1L;
    private long endNode = -1L;
    private int type;

    public RelationshipProxy(RelationshipActions actions, long id, long startNode, int type, long endNode) {
        this.actions = actions;
        this.visit(id, type, startNode, endNode);
    }

    public RelationshipProxy(RelationshipActions actions, long id) {
        this.actions = actions;
        this.id = id;
    }

    @Override
    public void visit(long id, int type, long startNode, long endNode) throws RuntimeException {
        this.id = id;
        this.type = type;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    private void initializeData() {
        if (this.startNode == -1L) {
            try (Statement statement = this.actions.statement();){
                statement.readOperations().relationshipVisit(this.getId(), this);
            }
            catch (EntityNotFoundException e) {
                throw new NotFoundException((Throwable)((Object)e));
            }
        }
    }

    public long getId() {
        return this.id;
    }

    private int typeId() {
        this.initializeData();
        return this.type;
    }

    private long sourceId() {
        this.initializeData();
        return this.startNode;
    }

    private long targetId() {
        this.initializeData();
        return this.endNode;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabaseService();
    }

    public void delete() {
        try (Statement statement = this.actions.statement();){
            statement.dataWriteOperations().relationshipDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Unable to delete relationship[" + this.getId() + "] since it is already deleted.");
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the relationship: " + e.getMessage(), e);
        }
    }

    public Node[] getNodes() {
        this.assertInUnterminatedTransaction();
        return new Node[]{this.actions.newNodeProxy(this.sourceId()), this.actions.newNodeProxy(this.targetId())};
    }

    public Node getOtherNode(Node node) {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.getOtherNodeId(node.getId()));
    }

    public Node getStartNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.sourceId());
    }

    public Node getEndNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.targetId());
    }

    public long getStartNodeId() {
        return this.sourceId();
    }

    public long getEndNodeId() {
        return this.targetId();
    }

    public long getOtherNodeId(long id) {
        long start = this.sourceId();
        long end = this.targetId();
        if (start == id) {
            return end;
        }
        if (end == id) {
            return start;
        }
        throw new NotFoundException("Node[" + id + "] not connected to this relationship[" + this.getId() + "]");
    }

    public RelationshipType getType() {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.actions.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            PrimitiveIntIterator properties = statement.readOperations().relationshipGetPropertyKeys(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship not found", (Throwable)((Object)e));
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.");
        }
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> getProperties(String ... keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> getAllProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Value value = statement.readOperations().relationshipGetProperty(this.getId(), propertyId);
            if (value == Values.NO_VALUE) {
                throw new PropertyNotFoundException(propertyId, EntityType.RELATIONSHIP, this.getId());
            }
            Object object = value.asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage((TokenNameLookup)new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            Value value = statement.readOperations().relationshipGetProperty(this.getId(), propertyId);
            Object object = value == Values.NO_VALUE ? defaultValue : value.asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = propertyId != -1 && statement.readOperations().relationshipHasProperty(this.getId(), propertyId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
    }

    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().relationshipSetProperty(this.getId(), propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (IllegalArgumentException e) {
            this.actions.failTransaction();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) {
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().relationshipRemoveProperty(this.getId(), propertyId).asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    public boolean isType(RelationshipType type) {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId()).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        try {
            String relType = this.actions.getRelationshipTypeById(this.typeId()).name();
            return String.format("(%d)-[%s,%d]->(%d)", this.sourceId(), relType, this.getId(), this.targetId());
        }
        catch (DatabaseShutdownException | NotInTransactionException throwable) {
            String relType = "RELTYPE(" + this.type + ")";
            return String.format("(?)-[%s,%d]->(?)", relType, this.getId());
        }
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }

    public static interface RelationshipActions {
        public Statement statement();

        public Node newNodeProxy(long var1);

        public RelationshipType getRelationshipTypeById(int var1);

        public GraphDatabaseService getGraphDatabaseService();

        public void failTransaction();

        public void assertInUnterminatedTransaction();
    }
}

