/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.explicitindex;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.explicitindex.AutoIndexOperations;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.storageengine.api.Token;
import org.neo4j.values.storable.Value;

public class InternalAutoIndexOperations
implements AutoIndexOperations {
    private AtomicReference<Set<String>> propertyKeysToInclude = new AtomicReference(Collections.emptySet());
    private final PropertyKeyTokenHolder propertyKeyLookup;
    private final EntityType type;
    private volatile boolean enabled;
    private volatile boolean indexCreated;

    public InternalAutoIndexOperations(PropertyKeyTokenHolder propertyKeyLookup, EntityType type) {
        this.propertyKeyLookup = propertyKeyLookup;
        this.type = type;
    }

    @Override
    public void propertyAdded(ExplicitIndexWrite ops, long entityId, int propertyKeyId, Value value) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name = ((Token)this.propertyKeyLookup.getTokenById(propertyKeyId)).name();
                if (this.propertyKeysToInclude.get().contains(name)) {
                    this.ensureIndexExists(ops);
                    this.type.add(ops, entityId, name, value.asObject());
                }
            }
            catch (KernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException((KernelException)((Object)new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)e)));
            }
        }
    }

    @Override
    public void propertyChanged(ExplicitIndexWrite ops, long entityId, int propertyKeyId, Value oldValue, Value newValue) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name = ((Token)this.propertyKeyLookup.getTokenById(propertyKeyId)).name();
                if (this.propertyKeysToInclude.get().contains(name)) {
                    this.ensureIndexExists(ops);
                    this.type.remove(ops, entityId, name, oldValue.asObject());
                    this.type.add(ops, entityId, name, newValue.asObject());
                }
            }
            catch (KernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException((KernelException)((Object)new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)e)));
            }
        }
    }

    @Override
    public void propertyRemoved(ExplicitIndexWrite ops, long entityId, int propertyKey) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name = ((Token)this.propertyKeyLookup.getTokenById(propertyKey)).name();
                if (this.propertyKeysToInclude.get().contains(name)) {
                    this.ensureIndexExists(ops);
                    this.type.remove(ops, entityId, name);
                }
            }
            catch (KernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException((KernelException)((Object)new PropertyKeyIdNotFoundKernelException(propertyKey, (Exception)e)));
            }
        }
    }

    @Override
    public void entityRemoved(ExplicitIndexWrite ops, long entityId) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                this.ensureIndexExists(ops);
                this.type.remove(ops, entityId);
            }
            catch (KernelException e) {
                throw new AutoIndexingKernelException(e);
            }
        }
    }

    void replacePropertyKeysToInclude(List<String> propertyKeysToIncludeNow) {
        HashSet<String> copiedPropertyKeysToIncludeNow = new HashSet<String>(propertyKeysToIncludeNow.size());
        copiedPropertyKeysToIncludeNow.addAll(propertyKeysToIncludeNow);
        this.propertyKeysToInclude.set(copiedPropertyKeysToIncludeNow);
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void startAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.getAndUpdate(current -> {
            HashSet<String> updated = new HashSet<String>();
            updated.addAll((Collection<String>)current);
            updated.add(propName);
            return updated;
        });
    }

    @Override
    public void stopAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.getAndUpdate(current -> {
            HashSet updated = new HashSet();
            updated.addAll(current);
            updated.remove(propName);
            return updated;
        });
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return Collections.unmodifiableSet(this.propertyKeysToInclude.get());
    }

    private void ensureIndexExists(ExplicitIndexWrite ops) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        if (!this.indexCreated) {
            this.type.ensureIndexExists(ops);
            this.indexCreated = true;
        }
    }

    public static enum EntityType {
        NODE{

            @Override
            public void add(ExplicitIndexWrite ops, long entityId, String keyName, Object value) throws KernelException {
                ops.nodeAddToExplicitIndex("node_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId, String keyName, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeRemoveFromExplicitIndex("node_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId, String keyName) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeRemoveFromExplicitIndex("node_auto_index", entityId, keyName);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId) throws ExplicitIndexNotFoundKernelException {
                ops.nodeRemoveFromExplicitIndex("node_auto_index", entityId);
            }

            @Override
            public void ensureIndexExists(ExplicitIndexWrite ops) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeExplicitIndexCreateLazily("node_auto_index", null);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public void add(ExplicitIndexWrite ops, long entityId, String keyName, Object value) throws KernelException {
                ops.relationshipAddToExplicitIndex("relationship_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId, String keyName, Object value) throws KernelException {
                ops.relationshipRemoveFromExplicitIndex("relationship_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId, String keyName) throws KernelException {
                ops.relationshipRemoveFromExplicitIndex("relationship_auto_index", entityId, keyName);
            }

            @Override
            public void remove(ExplicitIndexWrite ops, long entityId) throws KernelException {
                ops.relationshipRemoveFromExplicitIndex("relationship_auto_index", entityId);
            }

            @Override
            public void ensureIndexExists(ExplicitIndexWrite ops) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipExplicitIndexCreateLazily("relationship_auto_index", null);
            }
        };


        public abstract void add(ExplicitIndexWrite var1, long var2, String var4, Object var5) throws KernelException;

        public abstract void remove(ExplicitIndexWrite var1, long var2, String var4, Object var5) throws KernelException;

        public abstract void remove(ExplicitIndexWrite var1, long var2, String var4) throws KernelException;

        public abstract void remove(ExplicitIndexWrite var1, long var2) throws KernelException;

        public abstract void ensureIndexExists(ExplicitIndexWrite var1) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException;
    }
}

