/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.storageengine.api.EntityType;

public class EntityNotFoundException
extends KernelException {
    private final EntityType entityType;
    private final long entityId;

    public EntityNotFoundException(EntityType entityType, long entityId) {
        super((Status)Status.Statement.EntityNotFound, "Unable to load %s with id %s.", new Object[]{entityType.name(), entityId});
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public EntityType entityType() {
        if (this.entityType == null) {
            throw new IllegalStateException("No entity type specified for this exception", (Throwable)((Object)this));
        }
        return this.entityType;
    }

    public long entityId() {
        if (this.entityId == -1L) {
            throw new IllegalStateException("No entity id specified for this exception", (Throwable)((Object)this));
        }
        return this.entityId;
    }
}

