/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;

class NativeNonUniqueSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndexPopulator<KEY, VALUE> {
    private boolean updateSampling;
    private NonUniqueIndexSampler sampler;

    NativeNonUniqueSchemaNumberIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, indexId);
        this.sampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.include(SamplingUtil.encodedStringValuesForSampling(update.values()));
    }

    @Override
    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

