/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.api.cursor.TxAbstractPropertyCursor;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;

public class TxSinglePropertyCursor
extends TxAbstractPropertyCursor {
    private int propertyKeyId;
    private boolean seekFoundIt;

    public TxSinglePropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        super(instanceCache);
    }

    public Cursor<PropertyItem> init(Cursor<PropertyItem> cursor, PropertyContainerState state, int propertyKeyId) {
        super.init(cursor, state);
        this.propertyKeyId = propertyKeyId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        if (this.propertyKeyId == -1) {
            return false;
        }
        try {
            this.seekFoundIt = false;
            StorageProperty changedProperty = this.state.getChangedProperty(this.propertyKeyId);
            if (changedProperty != null) {
                this.property = changedProperty;
                boolean bl = true;
                return bl;
            }
            StorageProperty addedProperty = this.state.getAddedProperty(this.propertyKeyId);
            if (addedProperty != null) {
                this.property = addedProperty;
                boolean bl = true;
                return bl;
            }
            if (this.state.isPropertyRemoved(this.propertyKeyId)) {
                this.property = null;
                boolean bl = false;
                return bl;
            }
            if (this.cursor.next()) {
                this.property = null;
                this.seekFoundIt = true;
                boolean bl = true;
                return bl;
            }
            this.property = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.propertyKeyId = -1;
        }
    }

    @Override
    public PropertyItem get() {
        if (this.property == null && !this.seekFoundIt) {
            throw new IllegalStateException();
        }
        if (this.seekFoundIt) {
            this.property = new PropertyKeyValue(((PropertyItem)this.cursor.get()).propertyKeyId(), ((PropertyItem)this.cursor.get()).value());
        }
        this.seekFoundIt = false;
        return super.get();
    }
}

