/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.builtinprocs.NodePropertySchemaInfoResult;
import org.neo4j.kernel.builtinprocs.RelationshipPropertySchemaInfoResult;
import org.neo4j.kernel.builtinprocs.SortedLabels;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.Token;
import org.neo4j.values.storable.Value;

public class SchemaCalculator {
    private Map<Integer, String> propertyIdToPropertyNameMapping;
    private final Set<Integer> emptyPropertyIdSet = Collections.unmodifiableSet(Collections.emptySet());
    private final KernelTransaction ktx;

    SchemaCalculator(KernelTransaction ktx) {
        this.ktx = ktx;
    }

    private void initializePropertyMapping(ReadOperations readOperations) {
        this.propertyIdToPropertyNameMapping = new HashMap<Integer, String>(readOperations.propertyKeyCount());
        this.addNamesToCollection(readOperations.propertyKeyGetAllTokens(), this.propertyIdToPropertyNameMapping);
    }

    private NodeMappings initializeMappingsForNodes(ReadOperations readOps) {
        this.initializePropertyMapping(readOps);
        int labelCount = readOps.labelCount();
        return new NodeMappings(labelCount);
    }

    private RelationshipMappings initializeMappingsForRels(ReadOperations readOps) {
        this.initializePropertyMapping(readOps);
        int relationshipTypeCount = readOps.relationshipTypeCount();
        return new RelationshipMappings(relationshipTypeCount);
    }

    public Stream<NodePropertySchemaInfoResult> calculateTabularResultStreamForNodes() throws EntityNotFoundException {
        try (Statement statement = this.ktx.acquireStatement();){
            ReadOperations readOps = statement.readOperations();
            NodeMappings nodeMappings = this.initializeMappingsForNodes(readOps);
            this.scanEverythingBelongingToNodes(nodeMappings, readOps);
            this.addNamesToCollection(readOps.labelsGetAllTokens(), nodeMappings.labelIdToLabelName);
            Stream<NodePropertySchemaInfoResult> stream = this.produceResultsForNodes(nodeMappings).stream();
            return stream;
        }
    }

    public Stream<RelationshipPropertySchemaInfoResult> calculateTabularResultStreamForRels() throws EntityNotFoundException {
        try (Statement statement = this.ktx.acquireStatement();){
            ReadOperations readOps = statement.readOperations();
            RelationshipMappings relMappings = this.initializeMappingsForRels(readOps);
            this.scanEverythingBelongingToRelationships(relMappings, readOps);
            this.addNamesToCollection(readOps.relationshipTypesGetAllTokens(), relMappings.relationshipTypIdToRelationshipName);
            Stream<RelationshipPropertySchemaInfoResult> stream = this.produceResultsForRelationships(relMappings).stream();
            return stream;
        }
    }

    private List<RelationshipPropertySchemaInfoResult> produceResultsForRelationships(RelationshipMappings relMappings) {
        ArrayList<RelationshipPropertySchemaInfoResult> results = new ArrayList<RelationshipPropertySchemaInfoResult>();
        for (Integer typeId : relMappings.relationshipTypeIdToPropertyKeys.keySet()) {
            String name = relMappings.relationshipTypIdToRelationshipName.get(typeId);
            name = ":`" + name + "`";
            Set<Integer> propertyIds = relMappings.relationshipTypeIdToPropertyKeys.get(typeId);
            if (propertyIds.size() == 0) {
                results.add(new RelationshipPropertySchemaInfoResult(name, null, null, false));
                continue;
            }
            String finalName = name;
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertyNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(Pair.of((Object)typeId, (Object)propId));
                if (relMappings.nullableRelationshipTypes.contains(typeId)) {
                    results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), false));
                } else {
                    results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
                }
            });
        }
        return results;
    }

    private List<NodePropertySchemaInfoResult> produceResultsForNodes(NodeMappings nodeMappings) {
        ArrayList<NodePropertySchemaInfoResult> results = new ArrayList<NodePropertySchemaInfoResult>();
        for (SortedLabels labelSet : nodeMappings.labelSetToPropertyKeys.keySet()) {
            ArrayList<String> labelNames = new ArrayList<String>();
            for (int i = 0; i < labelSet.numberOfLabels(); ++i) {
                String name = nodeMappings.labelIdToLabelName.get(labelSet.label(i));
                labelNames.add(name);
            }
            Collections.sort(labelNames);
            StringBuilder labelsConcatenator = new StringBuilder();
            for (String item : labelNames) {
                labelsConcatenator.append(":`").append(item).append("`");
            }
            String labels = labelsConcatenator.toString();
            Set<Integer> propertyIds = nodeMappings.labelSetToPropertyKeys.get(labelSet);
            if (propertyIds.size() == 0) {
                results.add(new NodePropertySchemaInfoResult(labels, labelNames, null, null, false));
                continue;
            }
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertyNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(Pair.of((Object)labelSet, (Object)propId));
                if (nodeMappings.nullableLabelSets.contains(labelSet)) {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), false));
                } else {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
                }
            });
        }
        return results;
    }

    private void scanEverythingBelongingToRelationships(RelationshipMappings relMappings, ReadOperations readOps) throws EntityNotFoundException {
        PrimitiveLongIterator allRels = readOps.relationshipsGetAll();
        while (allRels.hasNext()) {
            long relId = allRels.next();
            RelationshipItem relationshipItem = (RelationshipItem)readOps.relationshipCursorById(relId).get();
            int typeId = relationshipItem.type();
            HashSet<Integer> propertyIds = new HashSet<Integer>();
            Cursor<PropertyItem> propertyCursor = readOps.relationshipGetProperties(relationshipItem);
            while (propertyCursor.next()) {
                PropertyItem propertyItem = (PropertyItem)propertyCursor.get();
                int propertyKey = propertyItem.propertyKeyId();
                Value currentValue = propertyItem.value();
                Pair key = Pair.of((Object)typeId, (Object)propertyKey);
                this.updateValueTypeInMapping(currentValue, key, relMappings.relationshipTypeIdANDPropertyTypeIdToValueType);
                propertyIds.add(propertyKey);
            }
            propertyCursor.close();
            Set<Integer> oldPropertyKeySet = relMappings.relationshipTypeIdToPropertyKeys.getOrDefault(typeId, this.emptyPropertyIdSet);
            if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                if (propertyIds.size() == 0) {
                    relMappings.nullableRelationshipTypes.add(typeId);
                }
                propertyIds.addAll(oldPropertyKeySet);
            } else {
                HashSet<Integer> currentPropertyIdsHelperSet = new HashSet<Integer>(propertyIds);
                currentPropertyIdsHelperSet.addAll(propertyIds);
                propertyIds.removeAll(oldPropertyKeySet);
                oldPropertyKeySet.removeAll(currentPropertyIdsHelperSet);
                propertyIds.addAll(oldPropertyKeySet);
                propertyIds.forEach(id -> {
                    Pair key = Pair.of((Object)typeId, (Object)id);
                    relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(key).setNullable();
                });
                propertyIds.addAll(currentPropertyIdsHelperSet);
            }
            relMappings.relationshipTypeIdToPropertyKeys.put(typeId, propertyIds);
        }
    }

    private void scanEverythingBelongingToNodes(NodeMappings nodeMappings, ReadOperations readOps) throws EntityNotFoundException {
        int[] labelHelper = new int[nodeMappings.getLabelCount()];
        PrimitiveLongIterator allNodes = readOps.nodesGetAll();
        while (allNodes.hasNext()) {
            long nodeId = allNodes.next();
            PrimitiveIntIterator labelIterator = readOps.nodeGetLabels(nodeId);
            int size = 0;
            while (labelIterator.hasNext()) {
                labelHelper[size] = labelIterator.next();
                ++size;
            }
            SortedLabels labels = SortedLabels.from(Arrays.copyOfRange(labelHelper, 0, size));
            HashSet<Integer> propertyIds = new HashSet<Integer>();
            PrimitiveIntIterator propertyKeys = readOps.nodeGetPropertyKeys(nodeId);
            while (propertyKeys.hasNext()) {
                int propertyKeyId = propertyKeys.next();
                Value currentValue = readOps.nodeGetProperty(nodeId, propertyKeyId);
                Pair key = Pair.of((Object)labels, (Object)propertyKeyId);
                this.updateValueTypeInMapping(currentValue, key, nodeMappings.labelSetANDNodePropertyKeyIdToValueType);
                propertyIds.add(propertyKeyId);
            }
            Set<Integer> oldPropertyKeySet = nodeMappings.labelSetToPropertyKeys.getOrDefault(labels, this.emptyPropertyIdSet);
            if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                if (propertyIds.size() == 0) {
                    nodeMappings.nullableLabelSets.add(labels);
                }
                propertyIds.addAll(oldPropertyKeySet);
            } else {
                HashSet<Integer> currentPropertyIdsHelperSet = new HashSet<Integer>(propertyIds);
                currentPropertyIdsHelperSet.addAll(propertyIds);
                propertyIds.removeAll(oldPropertyKeySet);
                oldPropertyKeySet.removeAll(currentPropertyIdsHelperSet);
                propertyIds.addAll(oldPropertyKeySet);
                propertyIds.forEach(id -> {
                    Pair key = Pair.of((Object)labels, (Object)id);
                    nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(key).setNullable();
                });
                propertyIds.addAll(currentPropertyIdsHelperSet);
            }
            nodeMappings.labelSetToPropertyKeys.put(labels, propertyIds);
        }
    }

    private <X, Y> void updateValueTypeInMapping(Value currentValue, Pair<X, Y> key, Map<Pair<X, Y>, ValueTypeListHelper> mappingToUpdate) {
        ValueTypeListHelper helper = mappingToUpdate.get(key);
        if (helper == null) {
            helper = new ValueTypeListHelper(currentValue);
            mappingToUpdate.put(key, helper);
        } else {
            helper.updateValueTypesWith(currentValue);
        }
    }

    private void addNamesToCollection(Iterator<Token> labelIterator, Map<Integer, String> collection) {
        while (labelIterator.hasNext()) {
            Token label = labelIterator.next();
            collection.put(label.id(), label.name());
        }
    }

    private class RelationshipMappings {
        final Map<Integer, String> relationshipTypIdToRelationshipName;
        final Map<Integer, Set<Integer>> relationshipTypeIdToPropertyKeys;
        final Map<Pair<Integer, Integer>, ValueTypeListHelper> relationshipTypeIdANDPropertyTypeIdToValueType;
        final Set<Integer> nullableRelationshipTypes;

        RelationshipMappings(int relationshipTypeCount) {
            this.relationshipTypIdToRelationshipName = new HashMap<Integer, String>(relationshipTypeCount);
            this.relationshipTypeIdToPropertyKeys = new HashMap<Integer, Set<Integer>>(relationshipTypeCount);
            this.relationshipTypeIdANDPropertyTypeIdToValueType = new HashMap<Pair<Integer, Integer>, ValueTypeListHelper>();
            this.nullableRelationshipTypes = new HashSet<Integer>();
        }
    }

    private class NodeMappings {
        final Map<SortedLabels, Set<Integer>> labelSetToPropertyKeys;
        final Map<Pair<SortedLabels, Integer>, ValueTypeListHelper> labelSetANDNodePropertyKeyIdToValueType;
        final Set<SortedLabels> nullableLabelSets;
        final Map<Integer, String> labelIdToLabelName;
        private final int labelCount;

        NodeMappings(int labelCount) {
            this.labelSetToPropertyKeys = new HashMap<SortedLabels, Set<Integer>>(labelCount);
            this.labelIdToLabelName = new HashMap<Integer, String>(labelCount);
            this.labelSetANDNodePropertyKeyIdToValueType = new HashMap<Pair<SortedLabels, Integer>, ValueTypeListHelper>();
            this.nullableLabelSets = new HashSet<SortedLabels>();
            this.labelCount = labelCount;
        }

        int getLabelCount() {
            return this.labelCount;
        }
    }

    private class ValueTypeListHelper {
        private Set<String> seenValueTypes = new HashSet<String>();
        private boolean isMandatory = true;

        ValueTypeListHelper(Value v) {
            this.updateValueTypesWith(v);
        }

        private void setNullable() {
            this.isMandatory = false;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        List<String> getCypherTypesList() {
            return new ArrayList<String>(this.seenValueTypes);
        }

        void updateValueTypesWith(Value newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException();
            }
            this.seenValueTypes.add(newValue.getTypeName());
        }
    }
}

