/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogTailScanner {
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fileSystem;
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;
    private LogTailInformation logTailInformation;

    public LogTailScanner(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader) {
        this.logFiles = logFiles;
        this.fileSystem = fileSystem;
        this.logEntryReader = logEntryReader;
    }

    private LogTailInformation update() throws IOException {
        PhysicalLogVersionedStoreChannel channel;
        long fromVersionBackwards;
        long version = fromVersionBackwards = this.logFiles.getHighestLogVersion();
        long versionToSearchForCommits = fromVersionBackwards;
        LogEntryStart latestStartEntry = null;
        LogEntryStart oldestStartEntry = null;
        long oldestVersionFound = -1L;
        LogEntryVersion latestLogEntryVersion = null;
        while (version >= 0L && (channel = PhysicalLogFile.tryOpenForVersion(this.logFiles, this.fileSystem, version, false)) != null) {
            oldestVersionFound = version;
            CheckPoint latestCheckPoint = null;
            ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS);
            boolean firstStartEntry = true;
            try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, recoveredDataChannel);){
                while (cursor.next()) {
                    LogEntry entry = cursor.get();
                    if (entry instanceof CheckPoint) {
                        latestCheckPoint = (CheckPoint)entry.as();
                    }
                    if (entry instanceof LogEntryStart) {
                        LogEntryStart startEntry = (LogEntryStart)entry.as();
                        if (version == versionToSearchForCommits) {
                            latestStartEntry = startEntry;
                        }
                        if (firstStartEntry) {
                            oldestStartEntry = startEntry;
                            firstStartEntry = false;
                        }
                    }
                    if (version != versionToSearchForCommits && latestLogEntryVersion != null) continue;
                    latestLogEntryVersion = entry.getVersion();
                }
            }
            if (latestCheckPoint != null) {
                return this.latestCheckPoint(fromVersionBackwards, version, latestStartEntry, oldestVersionFound, latestCheckPoint, latestLogEntryVersion);
            }
            --version;
            if (latestStartEntry != null) continue;
            --versionToSearchForCommits;
        }
        boolean commitsAfterCheckPoint = oldestStartEntry != null;
        long firstTxAfterPosition = commitsAfterCheckPoint ? this.extractFirstTxIdAfterPosition(oldestStartEntry.getStartPosition(), fromVersionBackwards) : LogTailInformation.NO_TRANSACTION_ID;
        return new LogTailInformation(null, commitsAfterCheckPoint, firstTxAfterPosition, oldestVersionFound, fromVersionBackwards, latestLogEntryVersion);
    }

    protected LogTailInformation latestCheckPoint(long fromVersionBackwards, long version, LogEntryStart latestStartEntry, long oldestVersionFound, CheckPoint latestCheckPoint, LogEntryVersion latestLogEntryVersion) throws IOException {
        boolean startEntryAfterCheckPoint;
        LogPosition target = latestCheckPoint.getLogPosition();
        boolean bl = startEntryAfterCheckPoint = latestStartEntry != null && latestStartEntry.getStartPosition().compareTo(target) >= 0;
        if (!startEntryAfterCheckPoint && target.getLogVersion() < version) {
            startEntryAfterCheckPoint = this.extractFirstTxIdAfterPosition(target, version) != LogTailInformation.NO_TRANSACTION_ID;
        }
        long firstTxIdAfterCheckPoint = startEntryAfterCheckPoint ? this.extractFirstTxIdAfterPosition(target, fromVersionBackwards) : LogTailInformation.NO_TRANSACTION_ID;
        return new LogTailInformation(latestCheckPoint, startEntryAfterCheckPoint, firstTxIdAfterCheckPoint, oldestVersionFound, fromVersionBackwards, latestLogEntryVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) throws IOException {
        LogPosition currentPosition = initialPosition;
        while (currentPosition.getLogVersion() <= maxLogVersion) {
            PhysicalLogVersionedStoreChannel storeChannel = PhysicalLogFile.tryOpenForVersion(this.logFiles, this.fileSystem, currentPosition.getLogVersion(), false);
            if (storeChannel != null) {
                try {
                    storeChannel.position(currentPosition.getByteOffset());
                    try (ReadAheadLogChannel logChannel = new ReadAheadLogChannel(storeChannel, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, logChannel);){
                        while (true) {
                            if (cursor.next()) {
                                LogEntry entry = cursor.get();
                                if (!(entry instanceof LogEntryCommit)) continue;
                                long l = ((LogEntryCommit)entry).getTxId();
                                return l;
                                continue;
                            }
                            break;
                        }
                    }
                }
                finally {
                    storeChannel.close();
                }
            }
            currentPosition = LogPosition.start(currentPosition.getLogVersion() + 1L);
        }
        return LogTailInformation.NO_TRANSACTION_ID;
    }

    public LogTailInformation getTailInformation() throws UnderlyingStorageException {
        if (this.logTailInformation == null) {
            try {
                this.logTailInformation = this.update();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Error encountered while parsing transaction logs", e);
            }
        }
        return this.logTailInformation;
    }

    public static class LogTailInformation {
        public static long NO_TRANSACTION_ID = -1L;
        public final CheckPoint lastCheckPoint;
        public final boolean commitsAfterLastCheckPoint;
        public final long firstTxIdAfterLastCheckPoint;
        public final long oldestLogVersionFound;
        public final long currentLogVersion;
        public final LogEntryVersion latestLogEntryVersion;

        public LogTailInformation(CheckPoint lastCheckPoint, boolean commitsAfterLastCheckPoint, long firstTxIdAfterLastCheckPoint, long oldestLogVersionFound, long currentLogVersion, LogEntryVersion latestLogEntryVersion) {
            this.lastCheckPoint = lastCheckPoint;
            this.commitsAfterLastCheckPoint = commitsAfterLastCheckPoint;
            this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
            this.oldestLogVersionFound = oldestLogVersionFound;
            this.currentLogVersion = currentLogVersion;
            this.latestLogEntryVersion = latestLogEntryVersion;
        }
    }
}

