/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DynamicArrayStore
extends AbstractDynamicStore {
    public static final int NUMBER_HEADER_SIZE = 3;
    public static final int STRING_HEADER_SIZE = 5;
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";

    public DynamicArrayStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat, String storeVersion, OpenOption ... openOptions) {
        super(fileName, configuration, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, dataSizeFromConfiguration, recordFormat, storeVersion, openOptions);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processArray(this, record);
    }

    public static void allocateFromNumbers(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator) {
        byte[] bytes;
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitiveByteArray = componentType.equals(Byte.TYPE);
        boolean isByteArray = componentType.equals(Byte.class) || isPrimitiveByteArray;
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        int arrayLength = Array.getLength(array);
        int requiredBits = isByteArray ? 8 : type.calculateRequiredBitsForArray(array, arrayLength);
        int totalBits = requiredBits * arrayLength;
        int numberOfBytes = (totalBits - 1) / 8 + 1;
        int bitsUsedInLastByte = totalBits % 8;
        bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        numberOfBytes += 3;
        if (isByteArray) {
            bytes = new byte[3 + arrayLength];
            bytes[0] = (byte)type.intValue();
            bytes[1] = (byte)bitsUsedInLastByte;
            bytes[2] = (byte)requiredBits;
            if (isPrimitiveByteArray) {
                System.arraycopy(array, 0, bytes, 3, arrayLength);
            } else {
                Byte[] source = (Byte[])array;
                for (int i = 0; i < source.length; ++i) {
                    bytes[3 + i] = source[i];
                }
            }
        } else {
            Bits bits = Bits.bits(numberOfBytes);
            bits.put((byte)type.intValue());
            bits.put((byte)bitsUsedInLastByte);
            bits.put((byte)requiredBits);
            type.writeAll(array, arrayLength, requiredBits, bits);
            bytes = bits.asBytes();
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes, recordAllocator);
    }

    private static void allocateFromString(Collection<DynamicRecord> target, String[] array, DynamicRecordAllocator recordAllocator) {
        byte[][] stringsAsBytes = new byte[array.length][];
        int totalBytesRequired = 5;
        for (int i = 0; i < array.length; ++i) {
            String string = array[i];
            byte[] bytes = PropertyStore.encodeString(string);
            stringsAsBytes[i] = bytes;
            totalBytesRequired += 4 + bytes.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytesRequired);
        buf.put(PropertyType.STRING.byteValue());
        buf.putInt(array.length);
        for (byte[] stringAsBytes : stringsAsBytes) {
            buf.putInt(stringAsBytes.length);
            buf.put(stringAsBytes);
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, buf.array(), recordAllocator);
    }

    public void allocateRecords(Collection<DynamicRecord> target, Object array) {
        DynamicArrayStore.allocateRecords(target, array, this);
    }

    public static void allocateRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            DynamicArrayStore.allocateFromString(target, (String[])array, recordAllocator);
        } else {
            DynamicArrayStore.allocateFromNumbers(target, array, recordAllocator);
        }
    }

    public static Value getRightArray(Pair<byte[], byte[]> data) {
        byte[] header = (byte[])data.first();
        byte[] bArray = (byte[])data.other();
        byte typeId = header[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header, 1, header.length - 1);
            int arrayLength = headerBuffer.getInt();
            String[] result = new String[arrayLength];
            ByteBuffer dataBuffer = ByteBuffer.wrap(bArray);
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = dataBuffer.getInt();
                byte[] stringByteArray = new byte[byteLength];
                dataBuffer.get(stringByteArray);
                result[i] = PropertyStore.decodeString(stringByteArray);
            }
            return Values.stringArray((String[])result);
        }
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = header[1];
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        if (type == ShortArray.BYTE && requiredBits == 8) {
            return Values.byteArray((byte[])bArray);
        }
        Bits bits = Bits.bitsFromBytes(bArray);
        int length = (bArray.length * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
        return type.createArray(length, bits, requiredBits);
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.readFullByteArray(records, PropertyType.ARRAY)).asObject();
    }
}

