/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.InvalidTransactionTypeException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class SchemaImpl
implements Schema {
    private final Supplier<Statement> statementContextSupplier;
    private final InternalSchemaActions actions;

    public SchemaImpl(Supplier<Statement> statementSupplier) {
        this.statementContextSupplier = statementSupplier;
        this.actions = new GDBSchemaActions(statementSupplier);
    }

    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    public Iterable<IndexDefinition> getIndexes(Label label) {
        try (Statement statement = this.statementContextSupplier.get();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<IndexDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<IndexDescriptor> indexes = statement.readOperations().indexesGetForLabel(labelId);
            this.addDefinitions(definitions, statement.readOperations(), IndexDescriptor.sortByType(indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    public Iterable<IndexDefinition> getIndexes() {
        try (Statement statement = this.statementContextSupplier.get();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            Iterator<IndexDescriptor> indexes = statement.readOperations().indexesGetAll();
            this.addDefinitions(definitions, statement.readOperations(), IndexDescriptor.sortByType(indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private IndexDefinition descriptorToDefinition(ReadOperations statement, IndexDescriptor index) {
        try {
            Label label = Label.label((String)statement.labelGetName(index.schema().getLabelId()));
            boolean constraintIndex = index.type() == IndexDescriptor.Type.UNIQUE;
            String[] propertyNames = PropertyNameUtils.getPropertyKeys(statement, index.schema().getPropertyIds());
            return new IndexDefinitionImpl(this.actions, label, propertyNames, constraintIndex);
        }
        catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, ReadOperations statement, Iterator<IndexDescriptor> indexes) {
        Iterators.addToCollection((Iterator)Iterators.map(index -> this.descriptorToDefinition(statement, (IndexDescriptor)index), indexes), definitions);
    }

    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + Iterators.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema.IndexState getIndexState(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            ReadOperations readOps = statement.readOperations();
            IndexDescriptor descriptor = SchemaImpl.getIndexDescriptor(readOps, index);
            InternalIndexState indexState = readOps.indexGetState(descriptor);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            ReadOperations readOps = statement.readOperations();
            IndexDescriptor descriptor = SchemaImpl.getIndexDescriptor(readOps, index);
            PopulationProgress progress = readOps.indexGetPopulationProgress(descriptor);
            IndexPopulationProgress indexPopulationProgress = new IndexPopulationProgress(progress.getCompleted(), progress.getTotal());
            return indexPopulationProgress;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIndexFailure(IndexDefinition index) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            ReadOperations readOps = statement.readOperations();
            IndexDescriptor descriptor = SchemaImpl.getIndexDescriptor(readOps, index);
            String string = readOps.indexGetFailure(descriptor);
            return string;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), index.getPropertyKeys()));
        }
    }

    public ConstraintCreator constraintFor(Label label) {
        this.actions.assertInOpenTransaction();
        return new BaseNodeConstraintCreator(this.actions, label);
    }

    public Iterable<ConstraintDefinition> getConstraints() {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            Iterator<ConstraintDescriptor> constraints = statement.readOperations().constraintsGetAll();
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<ConstraintDescriptor> constraints = statement.readOperations().constraintsGetForLabel(labelId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        this.actions.assertInOpenTransaction();
        try (Statement statement = this.statementContextSupplier.get();){
            int typeId = statement.readOperations().relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<ConstraintDescriptor> constraints = statement.readOperations().constraintsGetForRelationshipType(typeId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(constraints, statement.readOperations());
            return iterable;
        }
    }

    private static IndexDescriptor getIndexDescriptor(ReadOperations readOperations, IndexDefinition index) throws SchemaRuleNotFoundException {
        int labelId = readOperations.labelGetForName(index.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(readOperations, index.getPropertyKeys());
        SchemaImpl.assertValidLabel(index.getLabel(), labelId);
        SchemaImpl.assertValidProperties(index.getPropertyKeys(), propertyKeyIds);
        return readOperations.indexGetForSchema(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
    }

    private static void assertValidLabel(Label label, int labelId) {
        if (labelId == -1) {
            throw new NotFoundException(String.format("Label %s not found", label.name()));
        }
    }

    private static void assertValidProperties(Iterable<String> properties, int[] propertyIds) {
        for (int i = 0; i < propertyIds.length; ++i) {
            if (propertyIds[i] != -1) continue;
            throw new NotFoundException(String.format("Property key %s not found", ((String[])Iterables.asArray(String.class, properties))[i]));
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(Iterator<? extends ConstraintDescriptor> constraints, ReadOperations readOperations) {
        ArrayList<ConstraintDefinition> definitions = new ArrayList<ConstraintDefinition>();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = constraints.next();
            definitions.add(this.asConstraintDefinition(constraint, readOperations));
        }
        return definitions;
    }

    private ConstraintDefinition asConstraintDefinition(ConstraintDescriptor constraint, ReadOperations readOperations) {
        StatementTokenNameLookup lookup = new StatementTokenNameLookup(readOperations);
        if (constraint instanceof NodeExistenceConstraintDescriptor || constraint instanceof NodeKeyConstraintDescriptor || constraint instanceof UniquenessConstraintDescriptor) {
            LabelSchemaDescriptor schemaDescriptor = (LabelSchemaDescriptor)constraint.schema();
            Label label = Label.label((String)lookup.labelGetName(schemaDescriptor.getLabelId()));
            String[] propertyKeys = (String[])Arrays.stream(schemaDescriptor.getPropertyIds()).mapToObj(lookup::propertyKeyGetName).toArray(String[]::new);
            if (constraint instanceof NodeExistenceConstraintDescriptor) {
                return new NodePropertyExistenceConstraintDefinition(this.actions, label, propertyKeys);
            }
            if (constraint instanceof UniquenessConstraintDescriptor) {
                return new UniquenessConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, label, propertyKeys, true));
            }
            if (constraint instanceof NodeKeyConstraintDescriptor) {
                return new NodeKeyConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, label, propertyKeys, true));
            }
        } else if (constraint instanceof RelExistenceConstraintDescriptor) {
            RelationTypeSchemaDescriptor descriptor = (RelationTypeSchemaDescriptor)constraint.schema();
            return new RelationshipPropertyExistenceConstraintDefinition(this.actions, RelationshipType.withName((String)lookup.relationshipTypeGetName(descriptor.getRelTypeId())), lookup.propertyKeyGetName(descriptor.getPropertyId()));
        }
        throw new IllegalArgumentException("Unknown constraint " + constraint);
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final Supplier<Statement> ctxSupplier;

        GDBSchemaActions(Supplier<Statement> statementSupplier) {
            this.ctxSupplier = statementSupplier;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IndexDefinition createIndexDefinition(Label label, String ... propertyKeys) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                IndexDefinitionImpl indexDefinition = new IndexDefinitionImpl(this, label, propertyKeys, false);
                TokenWriteOperations tokenWriteOperations = statement.tokenWriteOperations();
                int labelId = tokenWriteOperations.labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWriteOperations, indexDefinition);
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
                statement.schemaWriteOperations().indexCreate(descriptor);
                IndexDefinitionImpl indexDefinitionImpl = indexDefinition;
                return indexDefinitionImpl;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    statement.schemaWriteOperations().indexDrop(SchemaImpl.getIndexDescriptor(statement.readOperations(), indexDefinition));
                }
                catch (NotFoundException notFoundException) {
                }
                catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())));
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(statement.tokenWriteOperations(), indexDefinition);
                statement.schemaWriteOperations().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                UniquenessConstraintDefinition uniquenessConstraintDefinition = new UniquenessConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return uniquenessConstraintDefinition;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new InvalidTransactionTypeException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(indexDefinition.getLabel().name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(statement.tokenWriteOperations(), indexDefinition);
                statement.schemaWriteOperations().nodeKeyConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodeKeyConstraintDefinition nodeKeyConstraintDefinition = new NodeKeyConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return nodeKeyConstraintDefinition;
            }
            catch (AlreadyConstrainedException | AlreadyIndexedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new InvalidTransactionTypeException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String ... propertyKeys) {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(statement.tokenWriteOperations(), propertyKeys);
                statement.schemaWriteOperations().nodePropertyExistenceConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodePropertyExistenceConstraintDefinition nodePropertyExistenceConstraintDefinition = new NodePropertyExistenceConstraintDefinition(this, label, propertyKeys);
                return nodePropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException e4) {
                        throw new InvalidTransactionTypeException(e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) throws CreateConstraintFailureException, AlreadyConstrainedException {
            Throwable throwable = null;
            try (Statement statement = this.ctxSupplier.get();){
                int typeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName(type.name());
                int[] propertyKeyId = PropertyNameUtils.getOrCreatePropertyKeyIds(statement.tokenWriteOperations(), propertyKey);
                statement.schemaWriteOperations().relationshipPropertyExistenceConstraintCreate(SchemaDescriptorFactory.forRelType(typeId, propertyKeyId));
                RelationshipPropertyExistenceConstraintDefinition relationshipPropertyExistenceConstraintDefinition = new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
                return relationshipPropertyExistenceConstraintDefinition;
            }
            catch (AlreadyConstrainedException | CreateConstraintFailureException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (InvalidTransactionTypeKernelException e3) {
                        throw new InvalidTransactionTypeException(e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String[] properties) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.readOperations().labelGetForName(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(statement.readOperations(), properties);
                    statement.schemaWriteOperations().constraintDrop(ConstraintDescriptorFactory.uniqueForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void dropNodeKeyConstraint(Label label, String[] properties) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.readOperations().labelGetForName(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(statement.readOperations(), properties);
                    statement.schemaWriteOperations().constraintDrop(ConstraintDescriptorFactory.nodeKeyForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String[] properties) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int labelId = statement.readOperations().labelGetForName(label.name());
                    int[] propertyKeyIds = PropertyNameUtils.getPropertyIds(statement.readOperations(), properties);
                    statement.schemaWriteOperations().constraintDrop(ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            try (Statement statement = this.ctxSupplier.get();){
                try {
                    int typeId = statement.readOperations().relationshipTypeGetForName(type.name());
                    int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
                    statement.schemaWriteOperations().constraintDrop(ConstraintDescriptorFactory.existsForRelType(typeId, propertyKeyId));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
                }
                catch (InvalidTransactionTypeKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            try (Statement statement = this.ctxSupplier.get();){
                String string = e.getUserMessage(new StatementTokenNameLookup(statement.readOperations()));
                return string;
            }
        }

        @Override
        public void assertInOpenTransaction() {
            this.ctxSupplier.get().close();
        }
    }
}

