/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Key;

public class StageExecution
implements StageControl {
    private final String stageName;
    private final Configuration config;
    private final Collection<Step<?>> pipeline;
    private long startTime;
    private final int orderingGuarantees;
    private volatile Throwable panic;

    public StageExecution(String stageName, Configuration config, Collection<Step<?>> pipeline, int orderingGuarantees) {
        this.stageName = stageName;
        this.config = config;
        this.pipeline = pipeline;
        this.orderingGuarantees = orderingGuarantees;
    }

    public boolean stillExecuting() {
        for (Step<?> step : this.pipeline) {
            if (step.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        for (Step<?> step : this.pipeline) {
            step.start(this.orderingGuarantees);
        }
    }

    public long getExecutionTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getStageName() {
        return this.stageName;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterable<Step<?>> steps() {
        return this.pipeline;
    }

    public Iterable<Pair<Step<?>, Float>> stepsOrderedBy(final Key stat, boolean trueForAscending) {
        final ArrayList steps = new ArrayList(this.pipeline);
        Collections.sort(steps, (o1, o2) -> {
            Long stat1 = o1.stats().stat(stat).asLong();
            Long stat2 = o2.stats().stat(stat).asLong();
            return trueForAscending ? stat1.compareTo(stat2) : stat2.compareTo(stat1);
        });
        return () -> new PrefetchingIterator<Pair<Step<?>, Float>>(){
            private final Iterator source;
            private Step next;
            {
                this.source = steps.iterator();
                this.next = this.source.hasNext() ? (Step)this.source.next() : null;
            }

            protected Pair<Step<?>, Float> fetchNextOrNull() {
                if (this.next == null) {
                    return null;
                }
                Step current = this.next;
                this.next = this.source.hasNext() ? (Step)this.source.next() : null;
                float factor = this.next != null ? (float)this.stat(current, stat) / (float)this.stat(this.next, stat) : 1.0f;
                return Pair.of((Object)current, (Object)Float.valueOf(factor));
            }

            private long stat(Step<?> step, Key stat12) {
                return step.stats().stat(stat12).asLong();
            }
        };
    }

    public int size() {
        return this.pipeline.size();
    }

    @Override
    public synchronized void panic(Throwable cause) {
        if (this.panic == null) {
            this.panic = cause;
            for (Step<?> step : this.pipeline) {
                step.receivePanic(cause);
            }
        } else if (!this.panic.equals(cause)) {
            this.panic.addSuppressed(cause);
        }
    }

    @Override
    public void assertHealthy() {
        if (this.panic != null) {
            throw Exceptions.launderedException((Throwable)this.panic);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.stageName + "]";
    }
}

