/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;

public class RunCarefully {
    private final Runnable[] operations;

    public RunCarefully(Runnable ... operations) {
        this.operations = operations;
    }

    public RunCarefully(Iterable<Runnable> operations) {
        this((Runnable[])Iterables.asArray(Runnable.class, operations));
    }

    public void run() {
        Throwable error = null;
        for (Runnable o : this.operations) {
            try {
                o.run();
            }
            catch (RuntimeException e) {
                error = Exceptions.combine(error, (Throwable)e);
            }
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
    }
}

