/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.locker.StoreLocker;

public class GlobalStoreLocker
extends StoreLocker {
    private static final Set<File> lockedFiles = Collections.newSetFromMap(new ConcurrentHashMap());

    public GlobalStoreLocker(FileSystemAbstraction fileSystemAbstraction, File storeDirectory) {
        super(fileSystemAbstraction, storeDirectory);
    }

    @Override
    public void checkLock() throws StoreLockException {
        super.checkLock();
        lockedFiles.add(this.storeLockFile);
    }

    @Override
    protected boolean haveLockAlready() {
        if (lockedFiles.contains(this.storeLockFile)) {
            if (this.storeLockFileLock != null) {
                return true;
            }
            throw this.unableToObtainLockException();
        }
        return false;
    }

    @Override
    protected void releaseLock() throws IOException {
        lockedFiles.remove(this.storeLockFile);
        super.releaseLock();
    }
}

