/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

public class NumberHitIterator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
    private final RawCursor<Hit<KEY, VALUE>, IOException> seeker;
    private final Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromWhenExhausted;
    private boolean closed;

    NumberHitIterator(RawCursor<Hit<KEY, VALUE>, IOException> seeker, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromWhenExhausted) {
        this.seeker = seeker;
        this.toRemoveFromWhenExhausted = toRemoveFromWhenExhausted;
    }

    protected boolean fetchNext() {
        try {
            if (!this.closed && this.seeker.next()) {
                return this.next(((SchemaNumberKey)((Object)((Hit)this.seeker.get()).key())).entityId);
            }
            this.ensureCursorClosed();
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ensureCursorClosed() throws IOException {
        if (!this.closed) {
            this.seeker.close();
            this.toRemoveFromWhenExhausted.remove(this.seeker);
            this.closed = true;
        }
    }
}

