/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class SchemaIndexProvider
extends LifecycleAdapter
implements Comparable<SchemaIndexProvider> {
    public static final SchemaIndexProvider NO_INDEX_PROVIDER = new SchemaIndexProvider(new Descriptor("no-index-provider", "1.0"), -1, IndexDirectoryStructure.NONE){
        private final IndexAccessor singleWriter = new IndexAccessor.Adapter();
        private final IndexPopulator singlePopulator = new IndexPopulator.Adapter();

        @Override
        public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singleWriter;
        }

        @Override
        public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
            return InternalIndexState.POPULATING;
        }

        @Override
        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
            return StoreMigrationParticipant.NOT_PARTICIPATING;
        }

        @Override
        public String getPopulationFailure(long indexId) throws IllegalStateException {
            throw new IllegalStateException();
        }
    };
    protected final int priority;
    private final Descriptor providerDescriptor;
    private final IndexDirectoryStructure.Factory directoryStructureFactory;
    private final IndexDirectoryStructure directoryStructure;

    protected SchemaIndexProvider(SchemaIndexProvider copySource) {
        this(copySource.providerDescriptor, copySource.priority, copySource.directoryStructureFactory);
    }

    protected SchemaIndexProvider(Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory) {
        this.directoryStructureFactory = directoryStructureFactory;
        assert (descriptor != null);
        this.priority = priority;
        this.providerDescriptor = descriptor;
        this.directoryStructure = directoryStructureFactory.forProvider(descriptor);
    }

    public abstract IndexPopulator getPopulator(long var1, IndexDescriptor var3, IndexSamplingConfig var4);

    public abstract IndexAccessor getOnlineAccessor(long var1, IndexDescriptor var3, IndexSamplingConfig var4) throws IOException;

    public abstract String getPopulationFailure(long var1) throws IllegalStateException;

    public abstract InternalIndexState getInitialState(long var1, IndexDescriptor var3);

    public Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public int compareTo(SchemaIndexProvider o) {
        return this.priority - o.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaIndexProvider other = (SchemaIndexProvider)o;
        return this.priority == other.priority && this.providerDescriptor.equals(other.providerDescriptor);
    }

    public int hashCode() {
        int result = this.priority;
        result = 31 * result + this.providerDescriptor.hashCode();
        return result;
    }

    public IndexDirectoryStructure directoryStructure() {
        return this.directoryStructure;
    }

    public abstract StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction var1, PageCache var2);

    public ResourceIterator<File> snapshotMetaFiles() {
        return Iterators.emptyResourceIterator();
    }

    public static class Descriptor {
        private final String key;
        private final String version;

        public Descriptor(String key, String version) {
            if (key == null) {
                throw new IllegalArgumentException("null provider key prohibited");
            }
            if (key.length() == 0) {
                throw new IllegalArgumentException("empty provider key prohibited");
            }
            if (version == null) {
                throw new IllegalArgumentException("null provider version prohibited");
            }
            this.key = key;
            this.version = version;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            return 23 + this.key.hashCode() ^ this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Descriptor) {
                Descriptor otherDescriptor = (Descriptor)obj;
                return this.key.equals(otherDescriptor.getKey()) && this.version.equals(otherDescriptor.getVersion());
            }
            return false;
        }

        public String toString() {
            return "{key=" + this.key + ", version=" + this.version + "}";
        }
    }
}

