/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.IntPredicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.util.Validators;

public class StoreViewNodeStoreScan<FAILURE extends Exception>
extends NodeStoreScan<FAILURE> {
    private final PropertyStore propertyStore;
    private final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor;
    private final Visitor<NodeUpdates, FAILURE> propertyUpdatesVisitor;
    private final IntPredicate propertyKeyIdFilter;
    protected final int[] labelIds;

    public StoreViewNodeStoreScan(NodeStore nodeStore, LockService locks, PropertyStore propertyStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<NodeUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter) {
        super(nodeStore, locks, nodeStore.getHighId());
        this.propertyStore = propertyStore;
        this.labelUpdateVisitor = labelUpdateVisitor;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
        this.labelIds = labelIds;
        this.propertyKeyIdFilter = propertyKeyIdFilter;
    }

    @Override
    protected PrimitiveLongResourceIterator getNodeIdIterator() {
        return super.getNodeIdIterator();
    }

    @Override
    public void process(NodeRecord node) throws FAILURE {
        long[] labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels.length == 0) {
            return;
        }
        if (this.labelUpdateVisitor != null) {
            this.labelUpdateVisitor.visit((Object)NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels));
        }
        if (this.propertyUpdatesVisitor != null && StoreViewNodeStoreScan.containsAnyLabel(this.labelIds, labels)) {
            NodeUpdates.Builder updates = NodeUpdates.forNode(node.getId(), labels);
            boolean hasRelevantProperty = false;
            for (PropertyBlock property : this.properties(node)) {
                int propertyKeyId = property.getKeyIndexId();
                if (!this.propertyKeyIdFilter.test(propertyKeyId)) continue;
                Object value = this.valueOf(property);
                Validators.INDEX_VALUE_VALIDATOR.validate(value);
                updates.added(propertyKeyId, value);
                hasRelevantProperty = true;
            }
            if (hasRelevantProperty) {
                this.propertyUpdatesVisitor.visit((Object)updates.build());
            }
        }
    }

    private Iterable<PropertyBlock> properties(NodeRecord node) {
        return () -> new PropertyBlockIterator(node);
    }

    private Object valueOf(PropertyBlock property) {
        this.propertyStore.ensureHeavy(property);
        return property.getType().getValue(property, this.propertyStore);
    }

    private static boolean containsAnyLabel(int[] labelIdFilter, long[] labels) {
        for (long candidate : labels) {
            if (!ArrayUtils.contains((int[])labelIdFilter, (int)Math.toIntExact(candidate))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate update, long currentlyIndexedNodeId) {
        if (update.getEntityId() <= currentlyIndexedNodeId) {
            updater.process(update);
        }
    }

    @Override
    public void configure(Collection<MultipleIndexPopulator.IndexPopulation> populations) {
        populations.forEach(population -> population.populator.configureSampling(true));
    }

    private class PropertyBlockIterator
    extends PrefetchingIterator<PropertyBlock> {
        private final Iterator<PropertyRecord> records;
        private Iterator<PropertyBlock> blocks = Collections.emptyIterator();

        PropertyBlockIterator(NodeRecord node) {
            long firstPropertyId = node.getNextProp();
            this.records = firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue() ? Collections.emptyIterator() : StoreViewNodeStoreScan.this.propertyStore.getPropertyRecordChain(firstPropertyId).iterator();
        }

        protected PropertyBlock fetchNextOrNull() {
            while (!this.blocks.hasNext()) {
                if (!this.records.hasNext()) {
                    return null;
                }
                this.blocks = this.records.next().iterator();
            }
            return this.blocks.next();
        }
    }
}

