/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValueConversion;

class UniqueSchemaNumberKey
implements SchemaNumberKey {
    static final int SIZE = 64;
    double value;
    boolean isHighest;

    UniqueSchemaNumberKey() {
    }

    @Override
    public void from(long entityId, Object[] values) {
        SchemaNumberValueConversion.assertValidSingleNumberPropertyValue(values);
        this.value = ((Number)values[0]).doubleValue();
        this.isHighest = false;
    }

    @Override
    public String propertiesAsString() {
        throw new UnsupportedOperationException("Implement me");
    }

    @Override
    public void initAsLowest() {
        this.value = Double.NEGATIVE_INFINITY;
        this.isHighest = false;
    }

    @Override
    public void initAsHighest() {
        this.value = Double.POSITIVE_INFINITY;
        this.isHighest = true;
    }

    public String toString() {
        return "compareValue=" + this.value;
    }
}

