/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.UniqueSchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.UniqueSchemaNumberValue;

class UniqueSchemaNumberIndexLayout
implements Layout<UniqueSchemaNumberKey, UniqueSchemaNumberValue> {
    private static final String IDENTIFIER_NAME = "UNI";

    UniqueSchemaNumberIndexLayout() {
    }

    public UniqueSchemaNumberKey newKey() {
        return new UniqueSchemaNumberKey();
    }

    public UniqueSchemaNumberKey copyKey(UniqueSchemaNumberKey key, UniqueSchemaNumberKey into) {
        into.value = key.value;
        into.isHighest = key.isHighest;
        return into;
    }

    public UniqueSchemaNumberValue newValue() {
        return new UniqueSchemaNumberValue();
    }

    public int keySize() {
        return 64;
    }

    public int valueSize() {
        return 136;
    }

    public void writeKey(PageCursor cursor, UniqueSchemaNumberKey key) {
        cursor.putLong(Double.doubleToRawLongBits(key.value));
    }

    public void readKey(PageCursor cursor, UniqueSchemaNumberKey into) {
        into.value = Double.longBitsToDouble(cursor.getLong());
    }

    public void writeValue(PageCursor cursor, UniqueSchemaNumberValue value) {
        cursor.putByte(value.type);
        cursor.putLong(value.rawValueBits);
        cursor.putLong(value.entityId);
    }

    public void readValue(PageCursor cursor, UniqueSchemaNumberValue into) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
        into.entityId = cursor.getLong();
    }

    public long identifier() {
        return Layout.namedIdentifier((String)IDENTIFIER_NAME, (int)136);
    }

    public int majorVersion() {
        return 0;
    }

    public int minorVersion() {
        return 1;
    }

    public int compare(UniqueSchemaNumberKey o1, UniqueSchemaNumberKey o2) {
        int comparison = Double.compare(o1.value, o2.value);
        if (comparison == 0) {
            if (o2.isHighest) {
                return -1;
            }
            if (o1.isHighest) {
                return 1;
            }
        }
        return comparison;
    }
}

