/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

class SchemaNumberValueConversion {
    SchemaNumberValueConversion() {
    }

    static void assertValidSingleNumberPropertyValue(Object[] values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!(values[0] instanceof Number)) {
            throw new IllegalArgumentException("Key layout does only support numbers, tried to create key from " + values[0]);
        }
    }

    static Number toValue(byte type, long rawValueBits) {
        switch (type) {
            case 0: {
                return rawValueBits;
            }
            case 1: {
                return Float.valueOf(Float.intBitsToFloat((int)rawValueBits));
            }
            case 2: {
                return Double.longBitsToDouble(rawValueBits);
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }
}

