/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

abstract class SchemaNumberValue {
    static final byte LONG = 0;
    static final byte FLOAT = 1;
    static final byte DOUBLE = 2;
    protected byte type;
    protected long rawValueBits;

    SchemaNumberValue() {
    }

    abstract void from(long var1, Object[] var3);

    abstract long getEntityId();

    byte type() {
        return this.type;
    }

    long rawValueBits() {
        return this.rawValueBits;
    }

    void extractValue(Number value) {
        if (value instanceof Double) {
            this.type = (byte)2;
            this.rawValueBits = Double.doubleToLongBits((Double)value);
        } else if (value instanceof Float) {
            this.type = 1;
            this.rawValueBits = Float.floatToIntBits(((Float)value).floatValue());
        } else {
            this.type = 0;
            this.rawValueBits = value.longValue();
        }
    }
}

