/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NonUniqueSchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.NonUniqueSchemaNumberValue;

public class NonUniqueSchemaNumberIndexLayout
implements Layout<NonUniqueSchemaNumberKey, NonUniqueSchemaNumberValue> {
    private static final String IDENTIFIER_NAME = "NUNI";

    public NonUniqueSchemaNumberKey newKey() {
        return new NonUniqueSchemaNumberKey();
    }

    public NonUniqueSchemaNumberKey copyKey(NonUniqueSchemaNumberKey key, NonUniqueSchemaNumberKey into) {
        into.value = key.value;
        into.entityId = key.entityId;
        return into;
    }

    public NonUniqueSchemaNumberValue newValue() {
        return new NonUniqueSchemaNumberValue();
    }

    public int keySize() {
        return 128;
    }

    public int valueSize() {
        return 72;
    }

    public void writeKey(PageCursor cursor, NonUniqueSchemaNumberKey key) {
        cursor.putLong(Double.doubleToRawLongBits(key.value));
        cursor.putLong(key.entityId);
    }

    public void writeValue(PageCursor cursor, NonUniqueSchemaNumberValue key) {
        cursor.putByte(key.type);
        cursor.putLong(key.rawValueBits);
    }

    public void readKey(PageCursor cursor, NonUniqueSchemaNumberKey into) {
        into.value = Double.longBitsToDouble(cursor.getLong());
        into.entityId = cursor.getLong();
    }

    public void readValue(PageCursor cursor, NonUniqueSchemaNumberValue into) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
    }

    public long identifier() {
        return Layout.namedIdentifier((String)IDENTIFIER_NAME, (int)72);
    }

    public int majorVersion() {
        return 0;
    }

    public int minorVersion() {
        return 1;
    }

    public int compare(NonUniqueSchemaNumberKey o1, NonUniqueSchemaNumberKey o2) {
        int compare = Double.compare(o1.value, o2.value);
        return compare != 0 ? compare : Long.compare(o1.entityId, o2.entityId);
    }
}

