/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.impl.index.GBPTreeUtil;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

public abstract class NativeSchemaIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexPopulator {
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_FAILED = 0;
    private final PageCache pageCache;
    private final File storeFile;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final ConflictDetectingValueMerger<VALUE> conflictDetectingValueMerger;
    protected final Layout<KEY, VALUE> layout;
    private Writer<KEY, VALUE> singleWriter;
    private byte[] failureBytes;
    private boolean dropped;
    GBPTree<KEY, VALUE> tree;

    NativeSchemaIndexPopulator(PageCache pageCache, File storeFile, Layout<KEY, VALUE> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.pageCache = pageCache;
        this.storeFile = storeFile;
        this.layout = layout;
        this.treeKey = (SchemaNumberKey)layout.newKey();
        this.treeValue = (SchemaNumberValue)layout.newValue();
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.conflictDetectingValueMerger = new ConflictDetectingValueMerger();
    }

    @Override
    public synchronized void create() throws IOException {
        GBPTreeUtil.deleteIfPresent(this.pageCache, this.storeFile);
        this.instantiateTree();
        this.instantiateWriter();
    }

    private void instantiateTree() throws IOException {
        this.tree = new GBPTree(this.pageCache, this.storeFile, this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER, this.recoveryCleanupWorkCollector);
    }

    void instantiateWriter() throws IOException {
        assert (this.singleWriter == null);
        this.singleWriter = this.tree.writer();
    }

    @Override
    public synchronized void drop() throws IOException {
        try {
            this.closeWriter();
            this.closeTree();
            GBPTreeUtil.deleteIfPresent(this.pageCache, this.storeFile);
        }
        finally {
            this.dropped = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        for (IndexEntryUpdate<?> update : updates) {
            this.add(update);
        }
    }

    @Override
    public void add(IndexEntryUpdate<?> update) throws IndexEntryConflictException, IOException {
        this.treeKey.from(update.getEntityId(), update.values());
        ((SchemaNumberValue)this.treeValue).from(update.getEntityId(), update.values());
        this.singleWriter.merge(this.treeKey, this.treeValue, this.conflictDetectingValueMerger);
        if (this.conflictDetectingValueMerger.wasConflict()) {
            long existingNodeId = this.conflictDetectingValueMerger.existingNodeId();
            long addedNodeId = this.conflictDetectingValueMerger.addedNodeId();
            throw new IndexEntryConflictException(existingNodeId, addedNodeId, OrderedPropertyValues.ofUndefined(update.values()));
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new NativeSchemaIndexUpdater();
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            this.closeWriter();
            if (populationCompletedSuccessfully && this.failureBytes != null) {
                throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
            }
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree();
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = "".getBytes();
        }
        this.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    private <T extends Closeable> T closeIfPresent(T closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
        return null;
    }

    void closeWriter() throws IOException {
        this.singleWriter = this.closeIfPresent((Closeable)this.singleWriter);
    }

    private void closeTree() throws IOException {
        this.tree = this.closeIfPresent((Closeable)this.tree);
    }

    private class NativeSchemaIndexUpdater
    implements IndexUpdater {
        private boolean closed;

        private NativeSchemaIndexUpdater() {
        }

        @Override
        public void process(IndexEntryUpdate update) throws IOException, IndexEntryConflictException {
            if (this.closed) {
                throw new IllegalStateException("Index updater has been closed.");
            }
            NativeSchemaIndexPopulator.this.add(update);
        }

        @Override
        public void remove(PrimitiveLongSet nodeIds) throws IOException {
            throw new UnsupportedOperationException("Implement me");
        }

        @Override
        public void close() throws IOException, IndexEntryConflictException {
            this.closed = true;
        }
    }
}

