/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.function.Consumer;
import org.neo4j.io.pagecache.PageCursor;

class FailureHeaderWriter
implements Consumer<PageCursor> {
    private final byte[] failureBytes;

    FailureHeaderWriter(byte[] failureBytes) {
        this.failureBytes = failureBytes;
    }

    @Override
    public void accept(PageCursor cursor) {
        byte[] bytesToWrite = this.failureBytes;
        cursor.putByte((byte)0);
        int availableSpace = cursor.getCurrentPageSize() - cursor.getOffset();
        if (bytesToWrite.length + 2 > availableSpace) {
            bytesToWrite = Arrays.copyOf(bytesToWrite, availableSpace - 2);
        }
        cursor.putShort((short)bytesToWrite.length);
        cursor.putBytes(bytesToWrite);
    }
}

