/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.pagecache.PageCache;

public class GBPTreeUtil {
    public static void delete(PageCache pageCache, File storeFile) throws IOException {
        FileHandle fileHandle = GBPTreeUtil.storeFileHandle(pageCache, storeFile);
        fileHandle.delete();
    }

    public static void deleteIfPresent(PageCache pageCache, File storeFile) throws IOException {
        try {
            GBPTreeUtil.delete(pageCache, storeFile);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static boolean storeFileExists(PageCache pageCache, File storeFile) {
        try {
            GBPTreeUtil.storeFileHandle(pageCache, storeFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static FileHandle storeFileHandle(PageCache pageCache, File storeFile) throws IOException {
        return (FileHandle)pageCache.getCachedFileSystem().streamFilesRecursive(storeFile).findFirst().get();
    }
}

