/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.Collection;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;

public abstract class BatchingRecordAccess<KEY, RECORD, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private final Collection<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> proxies = new ArrayCollection<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>>(1000);

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("We only support creations here");
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        RECORD record = this.createRecord(key, additionalData);
        BatchingRecordProxy proxy = new BatchingRecordProxy(key, record, additionalData);
        this.proxies.add(proxy);
        return proxy;
    }

    protected abstract RECORD createRecord(KEY var1, ADDITIONAL var2);

    public Iterable<RECORD> records() {
        return new IterableWrapper<RECORD, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>>(this.proxies){

            protected RECORD underlyingObjectToObject(RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> object) {
                return object.forReadingLinkage();
            }
        };
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setTo(KEY key, RECORD newRecord, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> setRecord(KEY key, RECORD record, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.proxies.size();
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> changes() {
        return this.proxies;
    }

    @Override
    public void close() {
        this.proxies.clear();
    }

    public static class BatchingRecordProxy<KEY, RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private final KEY key;
        private final RECORD record;
        private final ADDITIONAL additional;

        private BatchingRecordProxy(KEY key, RECORD record, ADDITIONAL additional) {
            this.key = key;
            this.record = record;
            this.additional = additional;
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forChangingData() {
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additional;
        }

        @Override
        public RECORD getBefore() {
            return null;
        }

        @Override
        public boolean isChanged() {
            return true;
        }

        @Override
        public boolean isCreated() {
            return true;
        }
    }
}

