/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class TxLabelIterator
extends PrimitiveIntCollections.PrimitiveIntBaseIterator {
    private PrimitiveIntIterator iterator;
    private ReadableDiffSets<Integer> labelDiffSet;
    private Iterator<Integer> added;

    public TxLabelIterator(PrimitiveIntIterator iterator, ReadableDiffSets<Integer> labelDiffSet) {
        this.iterator = iterator;
        this.labelDiffSet = labelDiffSet;
        this.added = null;
    }

    protected boolean fetchNext() {
        if (this.added == null) {
            while (this.iterator != null && this.iterator.hasNext()) {
                int label = this.iterator.next();
                if (this.labelDiffSet.isRemoved(label)) continue;
                this.next(label);
                return true;
            }
            this.added = this.labelDiffSet.getAdded().iterator();
        }
        if (this.added.hasNext()) {
            this.next(this.added.next());
            return true;
        }
        return false;
    }
}

