/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.MultiPropertyConstraintDefinition;

abstract class NodeConstraintDefinition
extends MultiPropertyConstraintDefinition {
    protected final Label label;

    protected NodeConstraintDefinition(InternalSchemaActions actions, Label label, String[] propertyKeys) {
        super(actions, propertyKeys);
        this.label = Objects.requireNonNull(label);
    }

    protected NodeConstraintDefinition(InternalSchemaActions actions, IndexDefinition indexDefinition) {
        super(actions, indexDefinition);
        this.label = Objects.requireNonNull(indexDefinition.getLabel());
    }

    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.label;
    }

    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("Constraint is associated with nodes");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConstraintDefinition that = (NodeConstraintDefinition)o;
        return this.label.name().equals(that.label.name()) && Arrays.equals(this.propertyKeys, that.propertyKeys);
    }

    protected String propertyText() {
        String nodeVariable = this.label.name().toLowerCase();
        if (this.propertyKeys.length == 1) {
            return nodeVariable + "." + this.propertyKeys[0];
        }
        return "(" + Arrays.stream(this.propertyKeys).map(p -> nodeVariable + "." + p).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public int hashCode() {
        return 31 * this.label.name().hashCode() + Arrays.hashCode(this.propertyKeys);
    }
}

