/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Predicate;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeType;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class RelationshipLinkStep
extends ForkedProcessorStep<RelationshipRecord[]> {
    protected final NodeRelationshipCache cache;
    private final int nodeTypes;
    private final Predicate<RelationshipRecord> filter;
    private final boolean forwards;

    public RelationshipLinkStep(StageControl control, Configuration config, NodeRelationshipCache cache, Predicate<RelationshipRecord> filter, int nodeTypes, boolean forwards) {
        super(control, "LINK", config);
        this.cache = cache;
        this.filter = filter;
        this.nodeTypes = nodeTypes;
        this.forwards = forwards;
    }

    @Override
    protected void forkedProcess(int id, int processors, RelationshipRecord[] batch) {
        int stride = this.forwards ? 1 : -1;
        int start = this.forwards ? 0 : batch.length - 1;
        int end = this.forwards ? batch.length : -1;
        for (int i = start; i != end; i += stride) {
            RelationshipRecord item = batch[i];
            if (item == null || !item.inUse() || this.process(item, id, processors)) continue;
            batch[i] = null;
        }
    }

    public boolean process(RelationshipRecord record, int id, int processors) {
        boolean isLoop;
        boolean processSecond;
        long startNode = record.getFirstNode();
        long endNode = record.getSecondNode();
        boolean processFirst = startNode % (long)processors == (long)id;
        boolean bl = processSecond = endNode % (long)processors == (long)id;
        if (!processFirst && !processSecond) {
            return true;
        }
        boolean firstIsDense = this.cache.isDense(startNode);
        boolean changed = false;
        boolean bl2 = isLoop = startNode == endNode;
        if (isLoop) {
            if (this.shouldChange(firstIsDense, record)) {
                if (processFirst) {
                    this.linkLoop(record);
                }
                changed = true;
            }
        } else {
            boolean secondIsDense;
            if (this.shouldChange(firstIsDense, record)) {
                if (processFirst) {
                    this.linkStart(record);
                }
                changed = true;
            }
            if (this.shouldChange(secondIsDense = this.cache.isDense(endNode), record)) {
                if (processSecond) {
                    this.linkEnd(record);
                }
                changed = true;
            }
        }
        return changed;
    }

    protected abstract void linkStart(RelationshipRecord var1);

    protected abstract void linkEnd(RelationshipRecord var1);

    protected abstract void linkLoop(RelationshipRecord var1);

    private boolean shouldChange(boolean isDense, RelationshipRecord record) {
        if (!NodeType.matchesDense(this.nodeTypes, isDense)) {
            return false;
        }
        return !isDense || this.filter == null || this.filter.test(record);
    }
}

