/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceException;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.storageengine.api.StorageProperty;

public interface TxStateVisitor
extends AutoCloseable {
    public static final TxStateVisitor EMPTY = new Adapter();

    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitCreatedRelationship(long var1, int var3, long var4, long var6) throws ConstraintValidationException;

    public void visitDeletedRelationship(long var1);

    public void visitNodePropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, Iterator<Integer> var5) throws ConstraintValidationException;

    public void visitRelPropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, Iterator<Integer> var5) throws ConstraintValidationException;

    public void visitGraphPropertyChanges(Iterator<StorageProperty> var1, Iterator<StorageProperty> var2, Iterator<Integer> var3);

    public void visitNodeLabelChanges(long var1, Set<Integer> var3, Set<Integer> var4) throws ConstraintValidationException;

    public void visitAddedIndex(IndexDescriptor var1);

    public void visitRemovedIndex(IndexDescriptor var1);

    public void visitAddedConstraint(ConstraintDescriptor var1) throws CreateConstraintFailureException;

    public void visitRemovedConstraint(ConstraintDescriptor var1);

    public void visitCreatedLabelToken(String var1, int var2);

    public void visitCreatedPropertyKeyToken(String var1, int var2);

    public void visitCreatedRelationshipTypeToken(String var1, int var2);

    @Override
    public void close();

    public static class Delegator
    implements TxStateVisitor {
        private final TxStateVisitor actual;

        public Delegator(TxStateVisitor actual) {
            assert (actual != null);
            this.actual = actual;
        }

        @Override
        public void visitCreatedNode(long id) {
            this.actual.visitCreatedNode(id);
        }

        @Override
        public void visitDeletedNode(long id) {
            this.actual.visitDeletedNode(id);
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
            this.actual.visitCreatedRelationship(id, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id) {
            this.actual.visitDeletedRelationship(id);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
            this.actual.visitNodePropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
            this.actual.visitRelPropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
            this.actual.visitGraphPropertyChanges(added, changed, removed);
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
            this.actual.visitNodeLabelChanges(id, added, removed);
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) {
            this.actual.visitAddedIndex(index);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
            this.actual.visitRemovedIndex(index);
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
            this.actual.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor constraint) {
            this.actual.visitRemovedConstraint(constraint);
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
            this.actual.visitCreatedLabelToken(name, id);
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
            this.actual.visitCreatedPropertyKeyToken(name, id);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
            this.actual.visitCreatedRelationshipTypeToken(name, id);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }

    public static class Adapter
    implements TxStateVisitor {
        @Override
        public void visitCreatedNode(long id) {
        }

        @Override
        public void visitDeletedNode(long id) {
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
        }

        @Override
        public void visitDeletedRelationship(long id) {
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws RelationshipPropertyExistenceException {
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) {
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor element) throws CreateConstraintFailureException {
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor element) {
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
        }

        @Override
        public void close() {
        }
    }
}

