/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.Service;

public class Version
extends Service {
    private final String artifactId;
    private final String title;
    private final String vendor;
    private final String version;
    private final String releaseVersion;
    static final String KERNEL_ARTIFACT_ID = "neo4j-kernel";
    private static final Version KERNEL_VERSION = new Version("neo4j-kernel", Version.class.getPackage().getImplementationVersion());

    public static Version getKernel() {
        return KERNEL_VERSION;
    }

    public static String getKernelVersion() {
        return Version.getKernel().getVersion();
    }

    public static String getNeo4jVersion() {
        return Version.getKernel().getReleaseVersion();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.title != null) {
            result.append(this.title);
            if (this.artifactId == null || !this.artifactId.equals(this.title)) {
                result.append(" (").append(this.artifactId).append(')');
            }
        } else if (this.artifactId != null) {
            result.append(this.artifactId);
        } else {
            result.append("Unknown Component");
        }
        result.append(", ");
        if (this.title == null) {
            result.append("unpackaged ");
        }
        result.append("version: ").append(this.getVersion());
        return result.toString();
    }

    public final String getVersion() {
        return this.version;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    protected Version(String artifactId, String version) {
        super(artifactId, new String[0]);
        this.artifactId = artifactId;
        this.title = artifactId;
        this.vendor = "Neo Technology";
        this.version = version == null ? "dev" : version;
        this.releaseVersion = this.parseReleaseVersion(this.version);
    }

    private String parseReleaseVersion(String fullVersion) {
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+(\\.\\d+)?(\\-?[^,]+)?).*");
        Matcher matcher = pattern.matcher(fullVersion);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return this.version;
    }

    public static void main(String[] args) {
        Version kernelVersion = Version.getKernel();
        System.out.println(kernelVersion);
        System.out.println("Title: " + kernelVersion.title);
        System.out.println("Vendor: " + kernelVersion.vendor);
        System.out.println("ArtifactId: " + kernelVersion.artifactId);
        System.out.println("Version: " + kernelVersion.getVersion());
    }
}

